      Program mod2b
! **********************************************************************
! *** This program is modified from the Euroben Benchmark V4.0.      ***
! ***                                                                ***
! *** Copyright: EuroBen Group p/o                                   ***
! ***            Utrecht University, Computational Physics Dept.     ***
! ***            P.O. Box 80.000                                     ***
! ***            3508 TA Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Author of this program: Ruud van der Pas                       ***
! *** Date                    11/24/1988                             ***
! *** Modified by:            Peter de Rijk                          ***
! *** Date                    02/12/1993                             ***
! *** Last modified by:       Aad van der Steen                      ***
! *** Date                    December 2001                          ***
! ***                         (Incorporated OpenMP)                  ***
! **********************************************************************
!  Version 4.0
!
! --- Purpose of program mod2b
!     -------------------------
!     This program solves a linear system Ax = b for a general matrix A
!     of orders as specified in the input file 'linful.in'.
!
! --- Remarks
!     -------
!     LAPACK and BLAS routines are used.
!
!     If (optimized) library versions for LAPACK and LINPACK are
!     available, you are asked to run a version of this program using
!     these versions.
! ----------------------------------------------------------------------
      Use                      numerics
      Implicit                 None

! --- Local Variables
!     ---------------
      Integer               :: i, lda, n, nprocs, nrep, ierr
      Integer               :: omp_get_num_threads
      Real(l_)              :: norma 
      Real(l_), Allocatable :: a(:,:), b(:)
      Integer, Allocatable  :: ipvt(:)
      Real(l_)              :: t1, time1, time2, totime, ops, speed
      Logical               :: ok
!
! --- External Functions
!     ------------------
      External                 wclock
      Real(l_)              :: wclock
!
!-----------------------------------------------------------------------
!                                  ** Print status information & header.
      Call state ( 'mod2b   ' )
      Open( 1, File = 'mod2b.in' )
!$omp parallel shared(nprocs)
      nprocs = omp_get_num_threads()
!$omp end parallel
      Print 1000, nprocs

!-----------------------------------------------------------------------
!               ** We use the right-looking Level 3 BLAS LAPACK version.

   10 Read( 1, *, End = 20 ) n, nrep
      lda = n + 1
      Allocate( a(lda,n), b(n), ipvt(n) )
      ops = ((2.0_l_*n)*n*n)/3.0_l_ + (2.0_l_*n)*n
      time1 = 0.0_l_
      time2 = 0.0_l_

! --- Generate the matrix.

      Do i = 1, nrep

         Call matgen( a, lda, n, b, norma )
!
         t1    = wclock()
         Call dgetrf( n, n, a, lda, ipvt, ierr )
         time1 = time1 + ( wclock() - t1 )

! --- Stop on error.

         If ( ierr /= 0 ) Then
            Print 2000, 'DGETRF', ierr
            Stop
         End If
!
         t1    = wclock()
         Call dgetrs( 'N', n, 1, a, lda, ipvt, b, n, ierr )
         time2 = time2 + ( wclock() - t1 )

! --- Stop on error.

         If ( ierr /= 0 ) Then
            Print 2000, 'DGETRS', ierr
            Stop
         End If
      End Do

! --- Check correctness.

      ok = .TRUE.
      Call check( b, n, ok )
      time1  = time1/nrep
      time2  = time2/nrep
      totime = time1 + time2
      speed  = 1.0e-6_l_*ops/Max( 1.0e-9_l_, totime )
      Print 1010, n,  time1, time2, totime, speed, ok
      Deallocate( a, b, ipvt )
      Go To 10
   20 Print 1020
! -----------------------------------------------------------------------
 1000 Format( 'Full linear solver test: No. of procs. = ', i3/
     &        '-----------------------------------------------',
     &        '-------------------'/,
     &        ' Order |  Factoris. |  Solving   |    Total   |',
     &        '    Speed   |     |'/,
     &        '   n   |  Time (s)  |  Time (s)  |  Time (s)  |',
     &        '  (Mflop/s) | OK? |'/, 
     &        '-----------------------------------------------'
     &        '-------------------' )
 1010 Format( I6, ' |', G11.4, ' |', G11.4, ' |', G11.4,' |', G11.4,
     &        ' |', L3, '  |' )
 1020 Format( '-----------------------------------------------',
     &        '-------------------' )
 2000 Format( I6 )
! -----------------------------------------------------------------------
      End Program mod2b
