      Subroutine spmxv( nrows, nelmts, indx, rowp, matvals, invec, 
     &                  outvec )
! ----------------------------------------------------------------------
! --- 'spmxv' does the actual matrix-vector multiply using the 
!     matrix in CRS format (indx, rowp, matvals) and producing
!     vector 'outvec'.
! ----------------------------------------------------------------------
      Use         numerics
      Implicit    None

      Integer  :: nrows, nelmts
      Integer  :: rowp(nrows), indx(nelmts)
      Real(l_) :: matvals(nelmts), invec(*), outvec(nrows)

      Integer  :: i, j
! ----------------------------------------------------------------------
!$omp parallel do
      Do i = 1, nrows
         outvec(i) = 0.0_l_
      End Do
!$omp parallel do
      Do i = 1, nrows - 1
         Do j = rowp(i), rowp(i+1) - 1
            outvec(i) = outvec(i) + matvals(indx(j))*invec(indx(j))
         End Do
      End Do    
      Do j = rowp(nrows), nelmts
         outvec(nrows) = outvec(nrows) + matvals(indx(j))*invec(indx(j))
      End Do
! ----------------------------------------------------------------------
      End Subroutine spmxv
