      Subroutine gendat( a, b, lda, m, l, n )
! ----------------------------------------------------------------------
! --- Routine 'gendat' generates matrix 'A' and 'B' for the
!     matrix-matrix multiplication 'C = AB'.
! ----------------------------------------------------------------------
      Use         numerics
      Implicit    None
      Integer  :: lda, m, l, n
      Real(l_) :: a(lda,l), b(l,n)

      Integer  :: i, j
! ----------------------------------------------------------------------
      Do i = 1, m
         a(i,1:l) = Real( i, l_ )
      End Do
      Do i = m+1, lda
         a(i,1:l) = 0.0_l_
      End Do
      Do j = 1, l
         b(j, 1:n) = 1.0_l_/Real( j, l_ )
      End Do
! ----------------------------------------------------------------------
      End Subroutine gendat
