      Subroutine check( c, m, l, n, ok )
! ----------------------------------------------------------------------
! --- Routine 'check' does the correctness check for the matrix-matrix
!     multiplication in routine 'mxm'. Because of the particular
!     data that are generated, this check can be used. 
! ----------------------------------------------------------------------
      Use        numerics
      Implicit   None
      Integer  :: m, l, n
      Real(l_) :: c(m,n)
      Logical  :: ok

      Integer  :: i, j
      Real(l_) :: eps, tvalue
! ----------------------------------------------------------------------
      tvalue = Real( l, l_ )
      eps = 2.0_l_*l*l*Epsilon( 1.0_l_ )
      Do j = 1, n
         Do i = 1, m
            ok = ok .AND. ( Abs( tvalue - c(i,j) ) <= eps )
         End Do
      End Do
! ----------------------------------------------------------------------
      End Subroutine check
