      Subroutine efvec( maxi, mrep, tab, nn, narr, ident, xint, yint )
! ---------------------------------------------------------------------
! --- EFVEC calculates the speed of the intrinsic functions on vectors
!     of arguments.
! ---------------------------------------------------------------------
      Use                   numerics
      Implicit              None

      Integer, Parameter  :: nfmax = 100, nmax = 50 
      Real(l_)            :: tab(nfmax,nmax)
      Integer             :: maxi, mrep, nn, narr(nmax)
      Character(8)        :: ident(nfmax)
      Real(l_)            :: xint(nfmax,2), yint(2)

      Real(l_), Parameter :: factor = 1.0e-6_l_,
     &                       pi = 3.14159265358979_l_, onep5 = 1.5_l_
      Integer             :: i, j, l, m, n, nrep
      Real(l_)            :: dt, t1, t2, ovhd
      Real(l_)            :: a, b, c, eps 
      Real(l_)            :: x(30000), y(30000)
      Real(l_)            :: cot, wclock
      External               cot, wclock

      Integer             :: it
      Real(l_)            :: xmin, xmax, beta
      Common /blmach/        xmin, xmax, beta, it

! --- Common to frustrate overoptimisation.
      Real(l_)            :: f
      Common /cfake/         f(30000)
! ---------------------------------------------------------------------
      m    = 0

! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  0.5_l_
      b =  1.0_l_
      ident(m) = 'xsq**1.5'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         Do i = 1, n
            x(i) = x(i)*x(i)
         End Do
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = x(i)**onep5
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep        
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n 
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  1.0_l_
      b =  Exp( Log( xmax )/3.0_l_ )
      ident(m) = 'xsq**1.5'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )          
         Do i = 1, n
            x(i) = x(i)*x(i)
         End Do
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = x(i)**onep5
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  0.01_l_
      b =  10.0_l_
      c = Max( Log( xmax ), -Log( xmin ) )/Log( 100.0_l_ )
      ident(m) = 'x**y'
      xint(m,1) = a
      xint(m,2) = b
      yint(1) = -c
      yint(2) =  c
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx(  a, b, n, x )
         Call argy( -c, c, n, y )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = x(i)**y(i)
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a = 0.0_l_
      b = pi*0.5_l_
      ident(m) = 'Sin'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Sin( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  6.0_l_*pi
      b =  a + pi*0.5_l_
      ident(m) = 'Sin'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Sin( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do

! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  7.0_l_*pi
      b =  a + pi*0.5_l_
      ident(m) = 'Cos'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Cos( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  0.5_l_
      b =  1.0_l_
      ident(m) = 'Sqrt'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Sqrt( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  1.0_l_
      b =  2.0_l_
      ident(m) = 'Sqrt'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Sqrt( x(i) )
            End Do
            Call ddummy( f, l )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  1.0_l_
      b =  xmax
      ident(m) = 'Sqrt'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Sqrt( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  -0.5_l_*Log( 2.0_l_ )+1.0_l_/16.0_l_
      b =   0.5_l_*Log( 2.0_l_ )
      ident(m) = 'Exp'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n ,x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Exp( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  -5.0_l_*Log ( 2.0_l_ )
      b =  Log( 4.0_l_*xmin*beta**it )
      ident(m) = 'Exp'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Exp( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  10.0_l_*Log( 2.0_l_ )
      b =  Max( 10.0_l_*a, Log( 0.9_l_*xmax ) )
      ident(m) = 'Exp'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1,nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Exp( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      eps = 1.0_l_
      Do i = 1, it/3
         eps = eps/beta
      End Do
      a =  1.0_l_ - eps
      b =  1.0_l_ + eps
      ident(m) = 'Log'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Log( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  Sqrt( 0.5_l_ )
      b =  15.0_l_/16.0_l_
      ident(m) = 'Log'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Log( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  Sqrt( 0.1_l_ )
      b =  0.9_l_
      ident(m) = 'Log10'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Log10( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  16.0_l_
      b =  240.0_l_
      ident(m) = 'Log'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Log( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  0.0_l_
      b =  pi/4.0_l_
      ident(m) = 'Tan'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Tan( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  pi*0.875_l_
      b =  1.125_l_*pi
      ident(m) = 'Tan'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Tan( x(i) )
            End Do
            Call ddummy( f, l )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  6.0_l_*pi
      b =  a + pi*0.25_l_
      ident(m) = 'Tan'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Tan( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  6.0_l_*pi
      b =  a + pi*0.25_l_
      ident(m) = 'Cot'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Cot( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  -0.125_l_
      b =   0.125_l_
      ident(m) = 'Asin'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Asin( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  -0.125_l_
      b =   0.125_l_
      ident(m) = 'Acos'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Acos( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  0.75_l_
      b =  1.0_l_
      ident(m) = 'Asin'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Asin( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  0.75_l_
      b =  1.0_l_
      ident(m) = 'Acos'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Acos( x(i ))
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  -1.0_l_
      b =  -0.75_l_
      ident(m) = 'Acos'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Acos( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  -1.0_l_/16.0_l_
      b =   1.0_l_/16.0_l_
      ident(m) = 'Atan'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Atan( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  1.0_l_/16.0_l_
      b =  2.0_l_-Sqrt( 3.0_l_ )
      ident(m) = 'Atan'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Atan( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  2.0_l_ - Sqrt( 3.0_l_ )
      b =  Sqrt( 2.0_l_ ) - 1.0_l_
      ident(m) = 'Atan'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Atan( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do

! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  Sqrt( 2.0_l_ ) - 1.0_l_
      b =  1.0_l_
      ident(m) = 'Atan'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Atan( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  0.0_l_
      b =  0.5_l_
      ident(m) = 'Sinh'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Sinh( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  0.0_l_
      b =  0.5_l_
      ident(m) = 'Cosh'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Cosh( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  3.0_l_
      b =  Log( xmax )
      ident(m) = 'Sinh'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Sinh( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  3.0_l_
      b =  Log( xmax )
      ident(m) = 'Cosh'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Cosh( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  0.125_l_
      b =  Log ( 3.0_l_ )*0.5_l_
      ident(m) = 'Tanh'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Tanh( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ---------------------------------------------------------------------
      m = m + 1
      If ( m > maxi ) Go To 900 
      a =  0.125_l_ + Log( 3.0_l_ )*0.5_l_
      b =  Log( 2.0_l_ ) + ( it + 1 )*Log( beta )*0.5_l_
      ident(m) = 'Tanh'
      xint(m,1) = a
      xint(m,2) = b
      Do l = 1, nn
         n = narr(l)
         nrep = mrep/n
         Call argx( a, b, n, x )
         t1 = wclock()
         Do j = 1, nrep
!$omp parallel do
            Do i = 1, n
               f(i) = Tanh( x(i) )
            End Do
            Call ddummy( f, j )
         End Do
         t2 = wclock() - t1

! --- Correct for overhead.
         ovhd = wclock()
         Do j = 1, nrep
            Call ddummy( f, j )
         End Do
         dt = ( t2 - wclock() + ovhd )/nrep 
         If ( dt > 0.0_l_ ) Then
            tab(m,l) = ( factor/dt )*n
         Else
            tab(m,l) = 999.999
         End If
      End Do
! ----------------------------------------------------------------------
 900  maxi = Min( maxi, m )
! ----------------------------------------------------------------------
      End Subroutine efvec
