      Program mod1d

! **********************************************************************
! *** This program is part of the EuroBen Benchmark                  ***
! *** Copyright: EuroBen Group p/o                                   ***
! ***            Utrecht University, High Performance Computing Group***
! ***            P.O. Box 80.195                                     ***
! ***            3508 TA Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Author of this program: Aad van der Steen                      ***
! *** Date                    January  1993                          ***
! *** Last modified           November 2001                          ***
! **********************************************************************
!  Version 4.0
!
! --- Synthetic Standard Benchmark Module 1d. Evaluates possible
!     memory bank conflicts by means of an daxpy operation with
!     strides /= 1 Both reading and writing elements with 
!     strides /= 1 are tested.
! --- NOTE: access to elements > hash = 1,049,599 (prime) are folded
!           back by means of the Mod function. When secondary caches
!           start to exceed 8 MB, both the 'length' and 'hash' should
!           be adjusted. 'hash' should preferably be prime but at
!           least it should not have factors < 'nmult'.
! ----------------------------------------------------------------------
      Use                     numerics
      Use                     sizes
      Implicit                None

      Integer, Parameter   :: maxinc = 50 , nmult = 10 000, nrep = 2 000
      Integer*8, Parameter :: hash   = 1 049 599

      Real(l_)             :: time1(maxinc), mflop1(maxinc),
     &                        time2(maxinc), mflop2(maxinc)
      Integer              :: inc(maxinc)
      Integer              :: i, j, k, minc, messn, nprocs
      Integer*8            :: linc
      Integer              :: omp_get_num_threads
      Real(l_)             :: sb, sy, corr
      Logical              :: ok1(maxinc), ok2(maxinc)

! --- External funtions
      Real(l_)             :: wclock
! ----------------------------------------------------------------------
! --- Call indentification routine.

      Call state('mod1d   ')
!$omp parallel shared(nprocs)
      nprocs = omp_get_num_threads()
!$omp end parallel

! --- Initialization; array 'a' is declared in module 'size'.

      a   = 1.0
      sb  = 1.0
      sy  = 0.0
      ok1 = .TRUE.
      ok2 = .TRUE.

! --- Get input.

      Call getInput( inc, maxinc, minc )

! --- Loop over strides inc(1),...,inc(minc) to do multiplies of length
!     nmult.

      Do k = 1, minc
         linc = inc(k)

! --- Cycle if linc is not a real increment.

         If ( linc < 0 ) Cycle

! --- Normal processing of strides.
            
         time1(k) = wclock()

! --- Repeat 'nrep' times for improved timing accuracy.
!     Test bank read behaviour; touch array 'a' before starting.

         a(1) = 1.0
         Do j = 1,nrep
            Call oper1( sy, nmult, linc, hash )
         End Do
         time1(k) = wclock() - time1(k)

! --- Correct for data manipulation overhead.

         corr = wclock()
         Do j = 1, nrep
            Call correct( nmult, linc, hash )        
         End Do
         corr = wclock() - corr
         time1(k) = (time1(k) - corr)/nrep
         mflop1(k) = 3.0e-6_l_*nmult/Max( time1(k), 1.0e-12_l_ )
         Call check1( sy, ok1(k) )

! --- Test bank write behaviour; touch array 'a' before starting.

         a(1) = 1.0
         time2(k) = wclock()
         Do j = 1,nrep
            Call oper2( nmult, linc, hash )
         End Do
         time2(k) = wclock() - time2(k)

! --- Correct for data manipulation overhead.

         corr = wclock()
         Do j = 1, nrep
            Call correct( nmult, linc, hash )        
         End Do
         corr = wclock() - corr
         time2(k)  = (time2(k) - corr)/nrep
         mflop2(k) = 3.0e-6_l_*nmult/Max( time2(k), 1.0e-12_l_ )
         Call check2( nmult, linc, hash, ok2(k) )
      End Do
! ----------------------------------------------------------------------
! --- Print results.

      Print 1000, nprocs

      messn = 0
      Do k = 1, minc
         linc = inc(k)
         If ( linc < 0 ) Then
            messn = messn + 1
            Cycle
         End If
         If ( messn == 0 ) Then
            Print 1100, linc, time1(k), mflop1(k), ok1(k), time2(k),
     &                  mflop2(k), ok2(k)
         Else If ( messn == 1 ) Then
            Print 1200, linc, time1(k), mflop1(k), ok1(k), time2(k),
     &                  mflop2(k), ok2(k)
         Else
            Print 1300, linc, time1(k), mflop1(k), ok1(k), time2(k),
     &                  mflop2(k), ok2(k)
         End If
      End Do
      Print 1400
      Print 1500
! ----------------------------------------------------------------------
! --- Formats.

 1000 Format( 'Test bank confilcts: No. of procs. = ', i3/
     &        '----------------------------------------------------',
     &        '--------------------------'/
     &        '|         |     Bank read conflict         ||'
     &        '      Bank write conflict       |'/
     &        '|------------------------------------------||-------',
     &        '-------------------------|'/
     &        '|  Stride |    Time(sec) |    Mflop/s   |OK||',
     &        '    Time(sec) |    Mflop/s   |OK|'/
     &        '|------------------------------------------||-------',
     &        '-------------------------|' )
 1100 Format( '| ', i7, ' |', g13.5, ' |', g13.5, ' |', l2, '||',
     &         g13.5, ' |', g13.5, ' |', l2, '|' )
 1200 Format( '| ', i7, ' |', g13.5, ' |', g13.5, ' |', l2, '||',
     &         g13.5, ' |', g13.5, ' |', l2, '|+' )
 1300 Format( '| ', i7, ' |', g13.5, ' |', g13.5, ' |', l2, '||',
     &         g13.5, ' |', g13.5, ' |', l2, '|*' )
 1400 Format( '----------------------------------------------------',
     &        '--------------------------' )
 1500 Format( /
     &       'Row entries ending with "+" address the secondary cache,'/
     &       'Row entries ending with "*" address main memory.' ) 
 
! ----------------------------------------------------------------------
      Stop
      End Program mod1d
