      Subroutine check2( nmult, linc, hash, ok )
! -------------------------------------------------------------------
! --- 'check2' checks whether the operations done in routine 'oper2'
!     have been performed correctly. The relevant elements of array
!     'a' have to be checked.
! -------------------------------------------------------------------
      Use                    numerics
      Use                    sizes !Defines type & size of array 'a'.
      Implicit               None

      Integer             :: nmult
      Integer*8           :: linc, hash
      Logical             :: ok

      Integer*8           :: i, l
      Real(l_)            :: eps
      Real(l_), Parameter :: sa = 0.5, sb = 0.5
      Logical             :: lok = .TRUE.
! -------------------------------------------------------------------
      eps = 5.0_l_*Epsilon( 1.0_l_ )
      Do i = 1, nmult
         l  = Abs( Mod( i*linc, hash ) )
         a(l) = a(i)*sa + a(i+1)*sb
         If ( Abs( a(l) - 1.0_l_ ) > eps ) lok = .FALSE.
         ok = ok .AND. lok
      End Do
! -------------------------------------------------------------------
      End Subroutine check2
