      Program mod2h
! **********************************************************************
! *** This program is part of the EuroBen Benchmark                  ***
! ***                                                                ***
! *** Copyright: EuroBen Group p/o                                   ***
! ***            Utrecht University, Computational Physics Dept.     ***
! ***            P.O. Box 80.000                                     ***
! ***            3508 TA Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Authors of this program: Aad van der Steen                     ***
! *** Date                    Spring 2003                            ***
! *** Adjustments of timing resolution and  problem set              ***
! *** by Aad van der Steen    Fall   2003                            ***
! **********************************************************************
!  Distributed Version 1.0
!
! --- EuroBen Benchmark Module 2h. Computes uniformly distributed random
!     numbers in the interval [0,1).
! ----------------------------------------------------------------------
      Use                      numerics
      Use                      ran_module
      Implicit                 None
      
      Real(l_), Allocatable :: a(:), timebf(:), time(:)
      Integer               :: n, nsize
      Integer               :: omp_get_num_threads, omp_get_thread_num
      Integer               :: me, nprocs
      Integer               :: er
      Integer(8)            :: x1, x2
      Real(l_)              :: gtime, nops
      Real(l_)              :: wclock
      Logical               :: ok
! ----------------------------------------------------------------------
! --- Call identification routine and start MPI.


      Call state( 'mod2h   ' )
!$omp parallel shared(nprocs)
      nprocs = omp_get_num_threads()
!$omp end parallel      
      Print 1000, nprocs
      Allocate( timebf(0:nprocs-1), time(0:nprocs-1) )      
! ----------------------------------------------------------------------
! --- Fill A with random numbers and include initialisation overhead
!     in the timing.

      Open( 1, File = 'mod2h.in' )
   10 Read( 1, *, End = 20 ) nsize
      n = nsize
      Allocate( a(n) )   
!$omp parallel private(me, x1, x2)
      me = omp_get_thread_num()    
      x1 = 2003                          ! --- Seeds for random process.
      x2 = 2017
      timebf(me) = wclock()
      Call rinit( n, a, nprocs, me, x1, x2 )
      Call ranfil( a, n, me, nprocs, x1, x2 )
      time(me) = wclock() - timebf(me)
!$omp end parallel      
      ok   = .TRUE.
      Call check( a, n, ok, nprocs )
      gtime = Maxval( time )
      nops = 1.0e-6_l_*nsize/Max( gtime, 1.0e-15_l_ )
      Print 1010, nsize, gtime, nops, ok
      Deallocate( a )
      Go To 10
   20 Print 1020
      Deallocate( timebf, time )
! ----------------------------------------------------------------------
 1000 Format(' Machine-independent random number generator dran2'/
     &       ' (including initialisation), nprocs = ', i3/
     &       '----------------------------------------'/
     &       '   Size |   Time(s)   |M rand.num/s |OK|'/
     &       '----------------------------------------' )
 1010 Format( i8, '|', g13.5, '|', g13.5, '|', l2, '|' )
 1020 Format('----------------------------------------' )
! ----------------------------------------------------------------------
      End Program mod2h
