      Subroutine check( a, b, m, n, err, jerr )
! ----------------------------------------------------------------------
! --- CHECK checks the errors made in the transformation of a
!     complex-to-complex FFT. CHECK is specific for the input
!     as produced in program 'mod2f' (shared-memory version).
!     The Real part is a full cycle of a cosine signal and the
!     Imaginary part is 0.0 everywhere.
!     The resulting transform should show values of float(N*M*NPROCS/2) 
!     for A(1,2) on node 1 and A(M,N) on node NPROCS. All other entries
!     should be 0.0D0. This is checked below with a Floating-Point
!     error margin of ERR = ( 10*N Log N )*EPS, with EPS the
!     Floating-Point spacing of the machine tested.
!
! --- The Real part of A is stored in A(1,1), ..., A(M,N);
!     the Imaginary part in B(1,1), ..., B(M,N).
!
! --- The elements that not meet the error criterion are normally
!     NOT printed. However, by decommenting the appropriate lines
!     all offending entries are printed. When the error criterion 
!     is exceeded by an element of A and/or B, the output parameter
!     JERR is increased by 1, So, after completion the total number
!     of errors is available in JERR.
! ----------------------------------------------------------------------
      Use              numerics
      Implicit         None

      Integer       :: m, n, jerr
      Real(l_)      :: a(m,n), b(m,n), err

      Integer       :: i, j, ntst
! ----------------------------------------------------------------------
      jerr = 0
      ntst = n*m
! ----------------------------------------------------------------------
! --- First check Imaginary elements (All these should be about 0.0D0).

      Do j = 1, n
         Do i = 1, m
            If ( Abs( b(i,j) ) > err ) Then
!              Print 1040, ntst , mbase + ( i - 1)*n + j, 
!    &                     b(i,j), err
               jerr = jerr + 1
            End If
         End Do
      End Do
! ----------------------------------------------------------------------
! --- Check Real elements in first node: A(1,2) should be about (N*M/2).

      If ( a(1,1) > err ) Then
         Print 1010, ntst, 1, a(1,1), err
         jerr = jerr + 1
      End If
      Do i = 3, m
         If ( Abs( a(i,1) ) > err ) Then
!           Print 1010, ntst , ( i - 1)*n + 1, a(i,2), err
            jerr = jerr + 1
         End If
      End Do
      Do j = 2, n
         Do i = 1, m - 1
            If ( Abs( a(i,j) ) > err ) Then
!              Print 1010, ntst, ( i - 1 )*n + j, a(i,j), err
               jerr = jerr + 1
            End If
         End Do
      End Do
      If ( Abs( a(2,1) - ntst/2.0_l_ ) > err ) Then
!        Print 1020, ntst, a(2,1), ntst/2.0_l_
         jerr = jerr + 1
      End If
      Do j = 2, n - 1
         If ( Abs( a(m,j) ) > err ) Then
!           Print 1010, ntst, ( m - 1 )*n + j, a(m,j), err
            jerr = jerr + 1
         End If
      End Do
      If ( Abs( a(m,n) - ntst/2.0_l_ ) > err ) Then
!        Print 1050, ntst, a(m,n), ntst/2.0_l_
         jerr = jerr + 1
      End If
! ----------------------------------------------------------------------
 1010 Format( 'Real element, Transform length = ', I7, 
     &        ' Element no. = ', I7, ' Value = ', 1Pg11.3,
     &        ' Should be <= ', 1Pg11.3 )
 1020 Format( 'Second Real element, Transform length = ', I7, 
     &        ' Value = ', 1Pg11.3, ' Should be ', 1Pg11.3 )
 1030 Format( 'N-th Real element, Transform length = ', I7,
     &        ' Value = ', 1Pg11.3, ' Should be ', 1Pg11.3 ) 
 1040 Format( 'Imaginary element, Transform length = ', I7,
     &        ' Element no. = ', I7, ' Value = ', 1Pg11.3,
     &        ' Should be <= ', 1Pg11.3 )
 1050 Format( 'Last Real element, Transform length = ', I7, 
     &        ' Value = ', 1Pg11.3, ' Should be ', 1Pg11.3 )
! ----------------------------------------------------------------------
      End Subroutine check
