      Program mod2d
! **********************************************************************
! *** This program is part of the EuroBen Benchmark                  ***
! *** Copyright: EuroBen Group p/o                                   ***
! ***            Utrecht University, Computational Physics Dept.     ***
! ***            P.O. Box 80195                                      ***
! ***            3508 TD Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Author of this program: Loes C.J. van Dam                      ***
! *** Contributed:            Spring 1999                            ***
! **********************************************************************
! --- Purpose of this program
!     -----------------------
!     This program calculates the eigenvalues of real symmetric 
!     matrices. The matrices are generated internally and eigenvalues
!     are calcultated by the LAPACK routine DSYEVD. The time and
!     Mflop/s of this operation are determined.
! ----------------------------------------------------------------------
      Use      numerics
      Implicit None
! ----------------------------------------------------------------------
      Integer, parameter    :: Nin = 1, okin = 2
      Real(l_), Allocatable :: A(:,:), AA(:,:), W(:)
      Real(l_)              :: time, speed, nflops
      Integer               :: i, linfo, N, nprocs, Nrep, stat
      Integer               :: omp_get_num_threads
      Character, Parameter  :: luplo = "L", jobz = "N"
      Logical               :: ok

! --- External functions and subroutines **
      Real(l_)              :: wclock
      Interface la_syevd

      Subroutine dsyevd_f90( a, w, jobz, uplo, info )
         Character(Len=1), Intent(In), Optional :: jobz, uplo
         Integer, Parameter             ::
     &                                  l_ = Selected_Real_Kind(15,307)
         Integer, Intent(Out), Optional :: info
         Real(l_), Intent(Inout)        :: a(:,:)
         Real(l_), Intent(Out)          :: w(:)
      End Subroutine dsyevd_f90

      END INTERFACE
! -------------------------------------------------------------------------
      Call state( 'mod2d   ' )
!$omp parallel shared(nprocs)
      nprocs = omp_get_num_threads()
!$omp end parallel
      Print 1000, nprocs
      Open( Unit = Nin, File = 'mod2d.in' )
! ** DO TESTS **
      Read(Nin, *) ! skip header in input file
      Do
            Read(Nin, *, Iostat = stat) N, Nrep
            If (stat < 0) Exit
            Allocate (A(N,N), AA(N,N), W(N))
            A = 0
            Call makmat (A, N)
            AA = A
! ** CALL AND TIME ROUTINE **
            time = wclock()
            Do i = 1, Nrep
                  Call la_syevd(A, W, jobz, luplo, linfo)
                  A = AA
            End Do
            time = (wclock() - time) / Nrep
! ** CHECK THE EIGENVALUES **
            Call check(N, A, W, ok)
! ** EVALUATING OUTPUT **		
            nflops = 2*(Real(N, l_)**3)
            speed = 1.0E-6_l_ * nflops / Max(time, 1.0E-9_l_)
            Print 1010, N, time, speed, ok
            Deallocate(A, AA, W)
      End Do
      Print 1020
! -------------------------------------------------------------------------
 1000 Format('Symmetric Eigenvalue problem test: No. of procs. = ', i3/
     &       '--------------------------------------------'/
     &       'Order |  Exec.Time(s) |    Mflop/s    | OK |'/
     &       '--------------------------------------------')
 1010 Format(I5, ' | ', G13.5,' | ', G13.5,' |  ', L1, ' |')
 1020 Format('--------------------------------------------')
! -------------------------------------------------------------------------
      End Program mod2d
