      Subroutine sym7icg0( n1, n2, n3, m, a, rmr, q, x, y, gamma )
! ---------------------------------------------------------------------
! --- ILU0 preconditioner. q and gamma are not used in this routine as
!     these parameters are only relevant for polynomial
!     preconditioning.

      Use         numerics
      Use         floptime
      Implicit    None

      Integer  :: n1, n2, n3, m
      Real(l_) :: a(n1*n2*n3,0:3), rmr, x(n1*n2*n3),y(n1*n2*n3)
      Real(l_) :: q(n1*n2*n3), gamma(m+1)
      Real(l_) :: nrm2

      Integer  :: i, ibw, n12, ntot
! ---------------------------------------------------------------------
! --- Forward solve: Corner.

      y(1) = x(1)
! ---------------------------------------------------------------------
! --- Forward solve: Rest.

      n12  = n1*n2
      ntot = n12*n3
      Do i = 2, n1
         y(i) = x(i) - a(i-1,1)*y(i-1)
      End Do
      Do i = n1 + 1, n12
         y(i) = x(i) - a(i-1,1)*y(i-1) - a(i-n1,2)*y(i-n1)
      End Do
      Do i = n12 + 1, ntot
         y(i) = x(i) - a(i-1,1)*y(i-1) - a(i-n1,2)*y(i-n1) -
     &          a(i-n12,3)*y(i-n12)
      End Do
! ---------------------------------------------------------------------
! --- Computation of (r,Mr) where M is the preconditioner.

      rmr = nrm2( ntot, y )
! ---------------------------------------------------------------------
! --- Back solve:

      ibw = ntot - 1
      Do i = 2, n1
         y(ibw) = y(ibw) - a(ibw,1)*y(ibw+1)
         ibw = ibw - 1
      End Do
      Do i = n1 + 1, n12
         y(ibw) = y(ibw) - ( a(ibw,1)*y(ibw+1) + a(ibw,2)*y(ibw+n1) )
         ibw = ibw - 1
      End Do
      Do i = n12 + 1, ntot
         y(ibw) = y(ibw) - ( a(ibw,1)*y(ibw+1) + a(ibw,2)*y(ibw+n1) +
     &                       a(ibw,3)*y(ibw+n12) )
         ibw = ibw - 1
      End Do

      flops = flops + 5*( n1 - 1 ) + 9*( n12 - n1 ) + 13*( ntot - n12 )
     &              + 2*ntot
! ---------------------------------------------------------------------
      End Subroutine sym7icg0
