      Subroutine rotb( arg, c, s )
! ----------------------------------------------------------------------
! --- Stores rotation factors arg according to sine/cosine terms of
!     Givens transformation (used in rgmres).
! ----------------------------------------------------------------------
      Use         numerics
      Use         floptime
      Implicit    None

      Real(l_) :: arg, c, s
! ----------------------------------------------------------------------
      If ( c == 0.0_l_ ) Then
         arg = 1.0_l_
      Else If ( Abs( s ) < Abs( c ) ) Then
         arg = 0.5_l_*s*Sign( 1.0_l_, c )
         flops = flops + 6
      Else
         arg = 2.0_l_*Sign( 1.0_l_, s )/c
         flops = flops + 6
      End If
! ----------------------------------------------------------------------
      End Subroutine rotb
