      Subroutine mxm( a, b, c, lda, m, l, n )
! ----------------------------------------------------------------------
! --- Routine 'mxm' does a matrix-matrix multiplication via a
!     vector update.
! ----------------------------------------------------------------------
      Use         numerics
      Implicit    None
      Integer  :: lda, m, l, n
      Real(l_) :: a(lda,l), b(l,n), c(m,n)

      Integer  :: i, j, k, lf
! ----------------------------------------------------------------------
      c  = 0.0_l_
      lf = l - Mod( l, 4 )
!$omp parallel do
      Do k = 1, n
         Do j = 1, lf, 4
            Do i = 1, m
               c(i,k) = c(i,k) + a(i,j)  *b(j,k)   + a(i,j+1)*b(j+1,k)
     &                         + a(i,j+2)*b(j+2,k) + a(i,j+3)*b(j+3,k)
            End Do
         End Do
      End Do
!$omp parallel do
      Do k = 1, n
         Do j = lf + 1, l
            Do i = 1, m
               c(i,k) = c(i,k) + a(i,j)*b(j,k)
            End Do
         End Do
      End Do
! ----------------------------------------------------------------------
      End Subroutine mxm
