      Subroutine mvddot( a, b, c, lda, m, n )
! ----------------------------------------------------------------------
! --- Routine 'mvddot' does a matrix-vector multiplication 'Ab = c'
!     using a dotproduct implementation.
! ----------------------------------------------------------------------
      Use         numerics
      Implicit    None
      Integer  :: lda, m, n
      Real(l_) :: a(lda,n), b(n), c(m)

      Integer  :: i, j, nf
      Real(l_) :: t1, t2, t3, t4
! ----------------------------------------------------------------------
      nf = n - Mod( n, 4 )
!$omp parallel do
      Do i = 1, m
         t1 = 0.0_l_; t2 = 0.0_l_;t3 = 0.0_l_;t4 = 0.0_l_
         Do j = 1, nf, 4
         t1 = t1 + a(i,j)  *b(j)
         t2 = t2 + a(i,j+1)*b(j+1)
         t3 = t3 + a(i,j+2)*b(j+2)
         t4 = t4 + a(i,j+3)*b(j+3)
         End Do
         c(i) = t1 + t2 + t3 + t4
      End Do
      c(nf+1:m) = 0.0_l_
      Do j = nf + 1, n
         c(1:m) = c(1:m) + a(1:m,j)*b(j)
      End Do
! ----------------------------------------------------------------------
      End Subroutine mvddot
