      Subroutine evdist( n )
! ---------------------------------------------------------------------
! --- Routine 'evdist' distributes 'n' elements as evenly as possible
!     over 'nodes' processors. The actual number of elements per
!     processor are returned in array 'sizes'.
! ---------------------------------------------------------------------
! --- Input:  - Integer n
!             - Integer nodes             (via Module dist_module).
! --- Output: - Integer sizes(0:maxnod-1) (via Module dist_module).
! ---------------------------------------------------------------------
      Use        dist_module
      Integer :: n

      Integer :: i, non, nrest, rest
! ---------------------------------------------------------------------
      non   = n/nodes
      rest  = Mod( n, nodes )
      nrest = nodes - rest - 1
      Do i = 0, nodes - 1
         sizes(i) = non
         If ( i > nrest ) sizes(i) = non + 1
      End Do
! ---------------------------------------------------------------------
      End Subroutine evdist
