      Subroutine dcheck( data, num, ok )
! ---------------------------------------------------------------------
! --- 'dcheck' checks sort runs on 8-byte Real arrays.
! ---------------------------------------------------------------------
      Use        numerics
      Use        dist_module
      Implicit   None
      Include    'mpif.h'

      Integer  :: num
      Real(l_) :: data(num)
      Logical  :: ok

      Integer  :: i, ier, status(MPI_Status_Size)
      Integer  :: itag
      Real(l_) :: exval
! ---------------------------------------------------------------------
      Do i = 2, num
         ok = ok .AND. ( data(i) - data(i-1) >= 0.0_l_ )
      End Do
      itag = 22222
      If ( nodes == 1 ) Return
      If ( me > 0 )         Call MPI_Send( data(1), 1, MPI_Real8,
     &                      me - 1, itag, MPI_Comm_World, ier )
      If ( me < nodes - 1 ) Call MPI_Recv( exval, 1, MPI_Real8,
     &                      me + 1, itag, MPI_Comm_World,
     &                      status, ier )
      If ( me < nodes - 1 ) ok = ok .AND.
     &                                  ( exval - data(num) >= 0.0_l_ )
! ---------------------------------------------------------------------
      End Subroutine dcheck
