      Subroutine check( a, n, ok )
! ---------------------------------------------------------------------
! --- Routine 'check' checks the correctness of the parallelly
!     generated random numbers by comparing them to a small sample
!     of the sequentially generated numbers.
! ---------------------------------------------------------------------
      Use                      numerics
      Use                      dist_module
      Use                      ran_module
      Implicit                 None
      Include                  'mpif.h'

      Integer               :: n
      Real(l_)              :: a(n)
      Logical               :: ok

      Real(l_), Allocatable :: testar(:), resultar(:)
      Real(l_)              :: dran0, eps
      Integer               :: i, er
! ---------------------------------------------------------------------
      eps = 10.0_l_*Epsilon( 1.0_l_ )
      Allocate( testar(2*nodes), resultar(nodes) )
      x1 = 2003
      x2 = 2017
      If ( me == 0 ) Then
         Do i = 1, 97
            x1 = Mod( a1*x1 + c1, m1 )
            x2 = Mod( a2*x2 + c2, m2 )
         End Do
         Do i = 1, 2*nodes
            testar(i) = dran0()
         End Do
      End If
      Call MPI_Gather( a(2), 1, MPI_Real8, resultar, 1, MPI_Real8,
     &                 0, MPI_Comm_World, er )
      If ( me == 0 ) Then
         Do i = 1, nodes
            ok = ok .AND. ( Abs( testar(nodes+i-1) - resultar(i) )
     &                      <= eps )
         End Do
      End If
      Deallocate( testar, resultar )
! ---------------------------------------------------------------------
      End Subroutine check

