      Subroutine check( a, w, hsize, n1, actsiz, ok )
! ---------------------------------------------------------------------
! --- Subroutine 'check' checks whether the transformed and
!     back-transformed array 'a' == 'w' within the precision 'eps'.
! ---------------------------------------------------------------------
      Use         numerics
      Use         dist_module ! Contains # of proc.s & proc. no.s 

      Integer  :: hsize, n1
      Real(l_) :: a(n1,hsize), w(n1,hsize)
      Integer  :: actsiz(0:nodes-1,2)
      Logical  :: ok

      Integer  :: i, j
      Real(l_) :: eps
! ---------------------------------------------------------------------
      eps = 4.0_l_*Epsilon( 1.0_l_ )
      Do j = 1, actsiz(me,2)
         Do i = 1, n1
            ok = ok .AND. ( Abs( a(i,j) - w(i,j) ) < eps )
         End Do
      End Do
! ---------------------------------------------------------------------
      End Subroutine check
