      Subroutine taylor( n1, n2, n3 )
! ----------------------------------------------------------------------
      Use        mpi_module
      Implicit   None

      Integer :: n1, n2, n3

      Integer :: m, n12, ntot, nsize
! ----------------------------------------------------------------------
      n12  = n1*n2
      ntot = n12*n3
      m    = sizes(me)
! ----------------------------------------------------------------------
! --- Determine bounds for upper diagonals.

      la1 = 1
      ua1 = m
      If ( me == ( nodes - 1 ) ) ua1 = ua1 - 1
      nsize = ntot - n1
      If ( glb > nsize ) Then
         la2 = ntot + 1         !<-- Make lower bound so high that loop
      Else                      !    never will execute.
         la2 = 1
      End If
      If ( nsize < gub ) Then
         ua2 = nsize - glb
      Else
         ua2 = m
      End If
      nsize = ntot - n12
      If ( glb > nsize ) Then
         la3 = ntot + 1         !<-- Make lower bound so high that loop
      Else                      !    never will execute.
         la3 = 1
      End If
      If ( nsize < gub ) Then
         ua3 = nsize - glb
      Else
         ua3 = m
      End If
! ----------------------------------------------------------------------
! --- Determine bounds for lower diagonals.

      lb1 = 1
      ub1 = m
      If ( me == 0 ) lb1 = 2
      nsize = n1
      If ( glb > nsize ) Then
         lb2 = 1
      Else
         lb2 = nsize - glb + 1
      End If
      If ( gub > nsize ) Then
         ub2 = m
      Else
         ub2 = 0                !<-- Make upper bound so low that loop
      End If                    !    will never execute.
      nsize = n12
      If ( glb > nsize ) Then
         lb3 = 1
      Else
         lb3 = nsize - glb + 1
      End If
      If ( gub > nsize ) Then
         ub3 = m
      Else
         ub3 = 0                !<-- Make upper bound so low that loop
      End If                    !    will never execute.
! ----------------------------------------------------------------------
      End Subroutine taylor
