      Subroutine sym7pol( n1, n2, n3, m, mp, a, al, rmr, x, y, gamma )
! ---------------------------------------------------------------------
! --- Polynomial (Neumann) preconditioner.
! ---------------------------------------------------------------------
      Use         numerics
      Use         floptime
      Use         mpi_module
      Implicit    None

      Integer  :: n1, n2, n3, m, mp
      Real(l_) :: a(m,0:3), al(m,1:3), x(n1*n2*n3), y(n1*n2*n3)
      Real(l_) :: gamma(mp+1)
      Real(l_) :: rmr

      Real(l_) :: w(n1*n2*n3)
      Integer  :: i
      Real(l_) :: nrm2
      External    nrm2
! ---------------------------------------------------------------------
      y(lb:gub) = gamma(mp+1)*x(lb:gub)
      Do i = 1, mp
         Call sym7mxv( n1, n2, n3, m, a, al, y, w )
         y(lb:gub) = y(lb:gub) - w(lb:gub)
         y(lb:gub) = y(lb:gub) + gamma(mp-i+1)*x(lb:gub)
      End Do
! ---------------------------------------------------------------------
! --- Computation of (r,Mr) where M is the preconditioner.

      rmr = nrm2( m, y(lb) )
      flops = flops + m*( 1 + 3*mp )
! ---------------------------------------------------------------------
      End Subroutine sym7pol
