      Subroutine sym7icg0( n1, n2, n3, m, mp, a, al, rmr, x, y, gamma )
! ---------------------------------------------------------------------
! --- ILU0 preconditioner. gamma is not used in this routine as
!     this parameter is only relevant for polynomial preconditioning.
! --- Note that this preconditioning is VERY approximate: the local 
!     parts of the matrix are treated as a complete matrix. So, 
!     influence of non-local parts is neglected.
! ---------------------------------------------------------------------

      Use         numerics
      Use         floptime
      Use         mpi_module
      Implicit    None

      Integer  :: n1, n2, n3, m, mp
      Real(l_) :: a(m,0:3), al(m,1:3), rmr, x(n1*n2*n3), y(n1*n2*n3)
      Real(l_) :: gamma(mp+1)

      Real(l_) :: nrm2
      External    nrm2

      Integer  :: i, n12
! ---------------------------------------------------------------------
! --- Forward solve: Corner.

      Call MPI_Allgatherv( x(lb), m, rtyp, x, sizes, offset, rtyp,
     &                     comm, ierr )
      y     = 0.0_l_
      y(lb) = x(lb)                      ! <-- Inexactness starts here!
! ---------------------------------------------------------------------
! --- Forward solve: Rest.

      n12  = n1*n2
      y(glb+lb1:glb+ub1) = x(glb+lb1:glb+ub1) - al(lb1:ub1,1)*
     &                     y(glb+lb1-1:glb+ub1-1)
      y(glb+lb2:glb+ub2) = y(glb+lb2:glb+ub2) - al(lb2:ub2,2)*
     &                     y(glb+lb2-1:glb+ub2-n1)
      y(glb+lb3:glb+ub3) = y(glb+lb3:glb+ub3) - al(lb3:ub3,3)*
     &                     y(glb+lb3-1:glb+ub3-n12)
! ---------------------------------------------------------------------
! --- Computation of (r,Mr) where M is the preconditioner.

      rmr = nrm2( m, y(lb) )
! ---------------------------------------------------------------------
! --- Back solve:

      Do i = ua1 - 1, la1, -1
         y(glb+i) = y(glb+i) - a(i,1)*y(glb+i+1)
      End Do
      Do i = ua2 - 1, la2, -1
         y(glb+i) = y(glb+i) - a(i,2)*y(glb+i+n1)
      End Do
      Do i = ua3 - 1, la3, -1
         y(glb+i) = y(glb+i) - a(i,3)*y(glb+i+n12)
      End Do

      flops = flops + 5*( n1 - 1 ) + 9*( n12 - n1 ) + 13*( m - n12 )
     &              + 2*m
! ---------------------------------------------------------------------
      End Subroutine sym7icg0
