      Subroutine sym7gen( ntot, m, a, b )
! ----------------------------------------------------------------------
! --- sym7gen generates the 4 upper diagonals of a 7-diagonal symmetric
!     matrix to be solved by a GC iterative solver. Also the RHS, b is
!     generated.
!     Real(l_) a(m:3)  : Matrix to be generated (local part, upper diag).
!     Real(l_) b(ntot) : Right hand side (local part in global array).
! ----------------------------------------------------------------------
      Use                    numerics
      Use                    mpi_module
      Use                    ran_module
      Implicit               None

      Integer             :: m, ntot
      Real(l_)            :: a(m,0:3)
      Real(l_)            :: b(ntot)

      Integer             :: i
      Real(l_)            :: offdg
! ----------------------------------------------------------------------
      a = 0.0_l_
      b = 0.0_l_
      x1 = 2005 + me; x2 = 2005 - 2*me             !<-- Set random seeds.
      Call rinit
      If ( la1 <= ua1 ) Call ranfil( a(la1,1), ua1 - la1 + 1 )   
      If ( la2 <= ua2 ) Call ranfil( a(la2,2), ua2 - la2 + 1 )   
      If ( la3 <= ua3 ) Call ranfil( a(la3,3), ua3 - la3 + 1 )   
      Do i = 1, m
         offdg  = Sum( a(i,1:3) )
         a(i,0) = 2.0_l_*offdg
      End Do
      Do i = 1, m
         If ( a(i,0) > 0.0_l_ ) a(i,1:3) = -a(i,1:3)/a(i,0)
         a(i,0)   = 1.0_l_
         b(glb+i) = Sum( a(i,1:3) ) + Sum( a(i,0:3) )
      End Do
! ----------------------------------------------------------------------
      End Subroutine sym7gen
