      Subroutine sym7com( m, n1, n2, ntot, a, al )
! ----------------------------------------------------------------------
! --- sym7com copies the 3 upper diagonals of matrix A ( a(*,1:3) )
!     into the array al(*,1:3) with the appropriate shifts.
! ----------------------------------------------------------------------
      Use         numerics
      Use         mpi_module
      Implicit    None

      Integer  :: m, n1, n2, ntot
      Real(l_) :: a(m,0:3), al(m,1:3)

      Real(l_) :: b(ntot)
      Integer  :: i, n12
! ----------------------------------------------------------------------
      n12   = n1*n2
      b     = 0.0_l_
      al    = 0.0_l_
      Call MPI_Allgatherv( a(1,1), m, rtyp, b, sizes, offset, rtyp,
     &                     comm, ierr )
      Do i = lb1, ub1
         al(i,1) = b(i+glb-1)
      End Do
      b = 0.0_l_
      Call MPI_Allgatherv( a(1,2), m, rtyp, b, sizes, offset, rtyp,
     &                     comm, ierr )
      Do i = lb2, ub2
         al(i,2) = b(i+glb-n1)
      End Do
      b = 0.0_l_
      Call MPI_Allgatherv( a(1,3), m, rtyp, b, sizes, offset, rtyp,
     &                     comm, ierr )
      Do i = lb3, ub3
         al(i,3) = b(i+glb-n12)
      End Do
! ----------------------------------------------------------------------
      End Subroutine sym7com
