      Subroutine pcoefs( m, gamma )
! ----------------------------------------------------------------------
! --- Routine 'pcoefs' provides the polynomial coefficients for a
!     left polynomial preconditioner to a degree <= 12.
!     Integer     m          : degree of polynomial.
!     Real(l_)    gamma(m+1) : Array of polynomial coefficients.
! ----------------------------------------------------------------------
      Use         numerics
      Implicit    None

      Integer  :: m
      Real(l_) :: gamma(m+1)
! ----------------------------------------------------------------------
      If ( m ==  1 ) Then
          gamma(1) = 6.0_l_/5.0_l_
          gamma(2) = 4.0_l_/5.0_l_
      Else If ( m == 2 ) Then
          gamma(1) =  8.0_l_/7.0_l_
          gamma(2) = 12.0_l_/7.0_l_
          gamma(3) =  8.0_l_/7.0_l_
      Else If ( m == 3 ) Then
          gamma(1) =  8.0_l_/9.0_l_
          gamma(2) =  4.0_l_/3.0_l_
          gamma(3) =  8.0_l_/3.0_l_
          gamma(4) = 16.0_l_/9.0_l_
      Else If ( m == 4 ) Then
          gamma(1) = 10.0_l_/11.0_l_
          gamma(2) =  4.0_l_/11.0_l_
          gamma(3) = 16.0_l_/11.0_l_
          gamma(4) = 48.0_l_/11.0_l_
          gamma(5) = 32.0_l_/11.0_l_
      Else If ( m == 5 ) Then
          gamma(1) =  14.0_l_/13.0_l_
          gamma(2) =   8.0_l_/13.0_l_
          gamma(3) = -16.0_l_/13.0_l_
          gamma(4) =  16.0_l_/13.0_l_
          gamma(5) =  96.0_l_/13.0_l_
          gamma(6) =  64.0_l_/13.0_l_
      Else If ( m == 6 ) Then
          gamma(1) =  16.0_l_/15.0_l_
          gamma(2) =   8.0_l_/5.0_l_
          gamma(3) =   0.0_l_
          gamma(4) = -16.0_l_/3.0_l_
          gamma(5) =   0.0_l_
          gamma(6) =  64.0_l_/5.0_l_
          gamma(7) = 128.0_l_/15.0_l_
      Else If ( m == 7 ) Then
          gamma(1) =   16.0_l_/17.0_l_
          gamma(2) =   24.0_l_/17.0_l_
          gamma(3) =   64.0_l_/17.0_l_
          gamma(4) =  -16.0_l_/17.0_l_
          gamma(5) = -256.0_l_/17.0_l_
          gamma(6) =  -64.0_l_/17.0_l_
          gamma(7) =  384.0_l_/17.0_l_
          gamma(8) =  256.0_l_/17.0_l_
      Else If ( m == 8 ) Then
          gamma(1) =   18.0_l_/19.0_l_
          gamma(2) =    8.0_l_/19.0_l_
          gamma(3) =   48.0_l_/19.0_l_
          gamma(4) =  208.0_l_/19.0_l_
          gamma(5) =  -32.0_l_/19.0_l_
          gamma(6) = -704.0_l_/19.0_l_
          gamma(7) = -256.0_l_/19.0_l_
          gamma(8) =  768.0_l_/19.0_l_
          gamma(9) =  512.0_l_/19.0_l_
      Else If ( m == 9 ) Then
          gamma(1)  =    22.0_l_/21.0_l_
          gamma(2)  =     4.0_l_/7.0_l_
          gamma(3)  =   -16.0_l_/7.0_l_
          gamma(4)  =    16.0_l_/3.0_l_
          gamma(5)  =    32.0_l_
          gamma(6)  =     0.0_l_
          gamma(7)  =  -256.0_l_/3.0_l_
          gamma(8)  =  -256.0_l_/7.0_l_
          gamma(9)  =   512.0_l_/7.0_l_
          gamma(10) =  1024.0_l_/21.0_l_
      Else If ( m == 10 ) Then
          gamma(1)  =    24.0_l_/23.0_l_
          gamma(2)  =    36.0_l_/23.0_l_
          gamma(3)  =   -24.0_l_/23.0_l_
          gamma(4)  =  -304.0_l_/23.0_l_
          gamma(5)  =   256.0_l_/23.0_l_
          gamma(6)  =  2048.0_l_/23.0_l_
          gamma(7)  =   256.0_l_/23.0_l_
          gamma(8)  = -4352.0_l_/23.0_l_
          gamma(9)  = -2048.0_l_/23.0_l_
          gamma(10) =  3072.0_l_/23.0_l_
          gamma(11) =  2048.0_l_/23.0_l_
      Else If ( m == 11 ) Then
          gamma(1)  =    24.0_l_/25.0_l_
          gamma(2)  =    36.0_l_/25.0_l_
          gamma(3)  =    24.0_l_/5.0_l_
          gamma(4)  =   -32.0_l_/5.0_l_
          gamma(5)  =  -256.0_l_/5.0_l_
          gamma(6)  =   512.0_l_/25.0_l_
          gamma(7)  =  5888.0_l_/25.0_l_
          gamma(8)  =   256.0_l_/5.0_l_
          gamma(9)  = -2048.0_l_/5.0_l_
          gamma(10) = -1024.0_l_/5.0_l_
          gamma(11) =  6144.0_l_/25.0_l_
          gamma(12) =  4096.0_l_/25.0_l_
      Else If ( m == 12 ) Then
          gamma(1)  =     26.0_l_/27.0_l_
          gamma(2)  =      4.0_l_/9.0_l_
          gamma(3)  =     32.0_l_/9.0_l_
          gamma(4)  =    544.0_l_/27.0_l_
          gamma(5)  =    -64.0_l_/3.0_l_
          gamma(6)  =   -512.0_l_/3.0_l_
          gamma(7)  =    256.0_l_/9.0_l_
          gamma(8)  =   1792.0_l_/3.0_l_
          gamma(9)  =    512.0_l_/3.0_l_
          gamma(10) = -23552.0_l_/27.0_l_
          gamma(11) =  -4096.0_l_/9.0_l_
          gamma(12) =   4096.0_l_/9.0_l_
          gamma(13) =   8192.0_l_/27.0_l_
      End If
! ----------------------------------------------------------------------
      End Subroutine pcoefs
