      Subroutine getf2( m, n, a, lda, ipiv, info )
! -----------------------------------------------------------------------
      Use         numerics
      Use         dist_module
      Implicit    None
      Include     'mpif.h'

      Integer  :: m, n, lda, info
      Integer  :: ipiv(*)
      Real(l_) :: a(lda,*)

      Integer  :: i, j, ip
      Integer  :: idmax
      Real(l_) :: pivcol(m-1)
      Integer  :: comm, ierr
! -----------------------------------------------------------------------
      info = 0
      comm = MPI_Comm_World

      Do i = 1, m
         j = localindex(i)
         If ( me == owner(i) ) Then
            ip = i - 1 + idmax( m-i+1, a(i,j), 1 )
            If ( a(ip,j) == 0.0_l_ ) ip = -ip
         End If 

         Call MPI_Bcast( ip, 1, MPI_Integer, owner(i), comm, ierr )

         ipiv(i) = Abs( ip )
         If ( ip > 0 ) Then
            If ( ip /= i ) Call swap( n, a(i,1), lda, a(ip,1), lda )
            If ( me == owner(i) ) Then
               Call scal( m-i, 1.0_l_/a(i,j), a(i+1,j), 1 )
            End If
         Else If ( info == 0 ) Then
            info = i
         End If

         If ( i < m ) Then
            If ( me == owner(i) ) Then
               pivcol(1:m-i) = a(i+1:m,j)
            Else
               j = j-1
            End If

            Call MPI_Bcast(pivcol, m-i, MPI_Real8, owner(I), comm, ierr)

            If ( j < n ) Call ger( m-i, n-j, -1.0_l_,
     &                        pivcol, 1, a(i,j+1), lda, a(i+1,j+1), lda)
         End If
      End Do      ! --- i-loop
! -----------------------------------------------------------------------
      End Subroutine getf2
