      Subroutine eberr( srname, info )
! ---------------------------------------------------------------------
      Integer     :: info
      Character*6 :: srname
! ---------------------------------------------------------------------
! --- EBERR is an error handler for the EuroBen mod2a routines.
!     It is called by the EuroBen mod2a routines if an input parameter
!     is invalid.
!
!     Parameters
!     ==========
!     SRNAME - Character*6.
!              On entry, SRNAME specifies the name of the routine which
!              called EBERR.
!     INFO   - INTEGER.
!              On entry, INFO specifies the position of the invalid
!              parameter in the parameter-list of the calling routine.
!
!     This routine is similar to and after the XERBLA routine for
!     the Levels 2 and 3 BLAS.
! ---------------------------------------------------------------------

      Write( *,9999 ) srname, info
      Stop
! ---------------------------------------------------------------------
 9999 Format ( ' ** On entry to ', A6, ' parameter number ', I2,
     &         ' had an illegal value' )
! ---------------------------------------------------------------------
      End Subroutine eberr
