      Function dmacdp( i )               Result( mpar )
      Use        numerics
      Integer  :: i
      Real(l_) :: mpar
! --------------------------------------------------------------------
! --- This function provides 8-byte precision machine parameters.
!     The Fortran 90 intrisics are employed to get the relevant
!     parameters.
!
! --- A reference to dmacdp(i) produces one of the machine parameters
!     where:
!
!     I is an integer input variable in the range [1,...,6] which
!         selects the desired machine parameter. If the machine has
!         T base B digits and its smallest and largest exponents are
!         EMIN and EMAX, respectively, then these parameters are:
!
!         dmacdp(1) = B**(1 - T), the relative machine precision 
!                                 (RELEPS), at 1.0D0
!         dmacdp(2) = B**(EMIN - 1), the smallest representable Real
!                                    number (RMIN),
!         dmacdp(3) = B**EMAX*(1 - B**(-T)), the largest representable
!                                            Real number (RMAX).
!         dmacdp(4) = T, N.B.: T is returned as a Real (Double 
!                              Precision) value (due to the restric-
!                              tions of Fortran functions). It 
!                              should be converted to type Integer
!                              after the function call to avoid
!                              type conflicts.
!         dmacdp(5) = B, N.B.: B is returned as a Real (Double 
!                              Precision) value (due to the restric-
!                              tions of Fortran functions). It 
!                              should be converted to type Integer
!                              after the function call to avoid
!                              type conflicts.
!         dmacdp(6) = P, N.B.: P is is the length in bits of the
!                              floating-point numbers used in the
!                              benchmark.
!                              It is returned as a Real (Double 
!                              Precision) value (due to the restric-
!                              tions of Fortran-77 functions). It 
!                              should be converted to type Integer
!                              after the function call to avoid
!                              type conflicts.
! ---------------------------------------------------------------------
      Real(l_), Parameter :: 
     &                       releps = 1.0_l_, rmin = 1.0_l_, 
     &                       rmax   = 1.0_l_, t    = 1.0_l_,
     &                       b      = 1.0_l_

!----------------------------------------------------------------------
! --- Return value according to value of 'i'.

      Select Case( i )
! ---------------------------------------------------------------------
! --- Relative machine precision:

      Case( 1 )
         mpar = Epsilon( releps )
! ---------------------------------------------------------------------
! --- Smallest representable f.p. number:

      Case( 2 )
         mpar = Tiny( rmin )
! ---------------------------------------------------------------------
! --- Largest representable f.p. number:

      Case( 3 )
         mpar = Huge( rmax )
! ---------------------------------------------------------------------
! --- Number of base B digits.

      Case( 4 ) 
         mpar = Digits( t )
! ---------------------------------------------------------------------
! --- Base B of floating-point representation.

      Case( 5 )
         mpar = Radix( b )
! ---------------------------------------------------------------------
! --- Number of bits in floating-point representation used: P.

      Case( 6 )
         p = Log( Dble( Maxexponent(b) ) )
         mpar =  p/Log( 2.0_l_ ) + Digits( b ) + 1.0_l_
! ---------------------------------------------------------------------
! --- i out of range:

      Case Default
         Print *, 'Parameter i out of range in function dmacdp:', i
         Stop    
      End Select
! ---------------------------------------------------------------------
      Return
      End
