      Subroutine check( rname, mode, y, ychk, lchk )
! ---------------------------------------------------------------------
! --- This is a routine that checks specifically for the correct
!     operation of the Matrix-vector multiply routines in program
!     'gmxv'. The matrix 'A' and the vector 'x' have the following
!     structure:
!           A:     n                   x:
!        __________/\______________
!       /                          \
!       _                      _    _   _    _   \
!    /  |  1    1    1    1   . . . |   |  1 |   |
!    |  |  1    2    3    4   . . . |   |  1 |   |
!    /  |  1    3    5    7   . . . |   |  1 |   |
!  m \  |  1    4    7   10   . . . |   |  1 |   |
!    |  |  .    .    .    .   . . . |   |  1 |   |
!    \  |  .    .    .    .   . . . |   |  1 |   |
!   -------------------------------------------- |
!    /  |  1  m+1  2m-1 3m-2  . . . |   |  2 |    \  Each of the
!    |  |  1  m+2  2m+1 3m+1  . . . |   |  2 |    /  'nodes' proc.'s
!    /  |  1  m+3  2m+3 3m+4  . . . |   |  2 |   |   contains a m x n
!  m \  |  1  m+4  2m+5 3m+7  . . . |   |  2 |   |   strip of A and
!    |  |  .   .     .   .    . . . |   |  2 |   |   the full vector x.
!    \  |  .   .     .   .    . . . |   |  2 |   |
!   -------------------------------------------- |
!                     .                    .     |
!                     .                    .     |
!                     .                    .    /
!
!     Vector 'y' should have elements that have values as
!     specified in routine 'mkbnds'. For each part of 'y' this 
!     condition is checked. If some part of 'y' is not meeting
!     this condition, a message is printed with the number of the node
!     where the incorrect result was found and the value of the
!     offending entry.
!
!     NOTE: m can have DIFFERENT values for DIFFERENT nodes!
!     These values are known via the array 'sizes' in Module
!     dist_module.
! ---------------------------------------------------------------------
      Use                   dist_module
      Use                   numerics
      Character          :: rname*6, mode*1
      Integer            :: lchk(*)
      Real(l_)           :: y(*), ychk(*)

      Real(l_)           :: dmacdp, eps
      Logical            :: ok
      Integer            :: i
! ---------------------------------------------------------------------
      ok = .TRUE.
      eps = Dble( nodes*sizes(me) )*dmacdp( 1 )
      Do i = 1, sizes(me)
         lchk(i) = 0
         ok = ok .AND. ( Abs ( y(i) - ychk(i) ) < eps )
         If ( .NOT. ok ) lchk(i) = i
      End Do      
      If ( .NOT. ok ) Then
         Print *, '**** For routine ' , rname, ' with mode ', mode
         Print *, 'Incorrect value(s) were found in the '
         Print *, 'result vector in node ', me
         Do i = 1, sizes(me)
            If ( lchk(i) /= 0 ) Print 1000, me, i, y(i), ychk(i)
         End Do
      End If
! ---------------------------------------------------------------------
 1000 Format( 'Node:', I5, 2X, 'Row:', I3, 2X, G13.5, 
     &        ' y(i) should be: ', G13.5 ) 
! ---------------------------------------------------------------------
      End Subroutine check
