      Program mod1j
! ----------------------------------------------------------------------
      Use                     numerics
      Use                     dist_module
      Implicit                None
      Include                 'mpif.h'

      Integer              :: comm, status, istat(MPI_Status_Size) 
      Integer              :: i, ireps, length, nreps
      Real(l_)             :: incpt, perc, slope, time
      Real(l_)             :: bw, bwmax, latency, lperc
      Logical              :: ok

      Integer, Allocatable :: message(:)
! ----------------------------------------------------------------------
! --- Initialise MPI.

      Call csetup
      comm = MPI_Comm_World

! --- Call identification routine.

      If ( me == 0 ) Then
          Call state('mod1j   ')
          Print 1000
      End If
! ----------------------------------------------------------------------
! --- If I am the first node, get data , send data, and wait for data
!     from the second node.
!     Also initialise the least-squares routine and max. bandwidth.
! ----------------------------------------------------------------------
      If ( me == 0 ) Then
         Call lsq( 0, 0.0_l_, 0.0_l_, slope, incpt, perc )
         bwmax = 0.0_l_
      End If
      Open( 1, File = 'mod1j.in' )
   10 Read( 1, *, End = 20 ) length, nreps
      Allocate( message(length) )
      If ( me == 0 ) Then
         Do i = 1, length
            message(i) = i
         End Do
      Else If ( me == 1 ) Then
         message = 0
      End If
! -----------------------------------------------------------------------
! --- Functional part: Perform transfer functions and time them.
! -----------------------------------------------------------------------
 
      If ( me == 0 ) Then
         time = MPI_Wtime()
         Do ireps = 1, nreps

! --- Send data to other processsor.
 
            Call MPI_Send( message, length, MPI_Integer, 1, 1, comm,
     &                     status )

! --- Now, get message back from the destination processor.
 
            Call MPI_Recv( message, length, MPI_Integer, 1, 2, comm,
     &                     istat, status )
         End Do

! --- Time again and divide by 2 to get communication time.
 
         time = ( MPI_Wtime() - time )/( 2.0_l_*nreps )
         If ( Abs( time ) <= 1.0e-14_l_ ) Then
             Print *, 'Time interval too short to measure', time
         Else
             Call lsq( 1, Real( length, l_ ), time, slope, incpt,
     &                 perc )
             If ( length == 30 ) Then
                latency = incpt*1.0e6_l_
                lperc   = perc
             End If
             bw = 1.0e-6_l_*Real( 4*length, l_ )/time
             bwmax = Max( bwmax, bw )
             ok = .TRUE.
             Call check( message, length, ok )
             Print 1010, 4*length, time, bw, ok
         End If
! ----------------------------------------------------------------------
      Else
! ----------------------------------------------------------------------
! --- This is the receiving processor that sends back the messages 
!     from processor 0 as soon as they are received.
! ----------------------------------------------------------------------
         Do ireps = 1, nreps
   
! --- Receive message from the sending processor and send it back
!     immediately.
 
            Call MPI_Recv( message, length, MPI_Integer, 0, 1, comm,
     &                     istat, status )
            Call MPI_Send( message, length, MPI_Integer, 0, 2, comm,
     &                     status )
         End Do
      End If
! ----------------------------------------------------------------------
      Deallocate( message )
      Go To 10
   20 If ( me == 0 ) Then
         Print 1020
         Print 1030, bwmax, latency, lperc
      End If
      Call MPI_Finalize( istat )
! ----------------------------------------------------------------------
 1000 Format('Program mod1j: measure distributed memory communication'/
     &       '-------------------------------------------------------'/
     &       '| Mess. length | Transfer time |   Bandwidth   |   |'/
     &       '|    (Bytes)   |    (seconds)  |   (Mbyte/s)   |OK?|'/
     &       '----------------------------------------------------' )
 1010 Format('|', 3x, i8, 3x, '|', 1x, g13.5, 1x, '|', 1x, g13.5, 1x,
     &       '|', l2,' |' )
 1020 Format('----------------------------------------------------' )
 1030 Format( 'Maximum bandwidth = ' g12.5, ' MB/s'/
     &        'Latency   = ', g11.4, ' microsec., Error = ', f6.2, '%'/
     &        '-------------------------------------------------------')
! ----------------------------------------------------------------------
      End Program mod1j
