      Program mod1h
**********************************************************************
*** This program is part of the EuroBen distributed                ***
*** memory Benchmark.                                              ***
***                                                                ***
*** Copyright: European Benchmark Group p/o                        ***
***            Utrecht University, Computational Physics Dept.     ***
***            P.O. Box 80195                                      ***
***            3508 TD Utrecht                                     ***
***            The Netherlands                                     ***
***                                                                ***
*** Authors of this program: Charles Grassl (SGI),                 ***
*** Michiel van den Hout, Aad van der Steen, Utrecht University,   ***
*** Computational Physics Dept.                                    ***
*** Date                    Spring 1999                            ***
**********************************************************************
! ---------------------------------------------------------------------
      Use             numerics
      Use             max_params
      Implicit        None
      Include         'mpif.h'

      Character*50 :: title
      Real(l_)     :: tn(maxcases), ops
      Integer      :: log2n, nrpt, ncases
      Integer      :: me, npes, n
      Integer      :: comm, ie
      Logical      :: first, last
      External        ping2, ping2_i, broadcast, collect, reduction,
     &                trans_2d, bisec2_reg, bisec2_rand, nearn_1d, 
     &                nearn_2d, nearn_3d
! ---------------------------------------------------------------------
      comm = MPI_Comm_World
      
      Call MPI_Init( ie )
      Call MPI_Comm_rank( comm, me, ie )
      Call MPI_Comm_size( comm, npes, ie )
      If ( me == 0 ) Call state( 'mod1h   ' )
      first = .TRUE.
      last  = .FALSE.     
      Do log2n = 0, log2nmax
         n    = 2**log2n
         last = log2n .EQ. log2nmax 
         Call hull( ping2, title, me, npes, nrpt, ncases, n, tn,
     &              ops )
         Call report( title, me, npes, nrpt, ncases, n, tn, ops,
     &                first, last )
      End Do

      Do log2n = 0, log2nmax
         n    = 2**log2n
         last = log2n .EQ. log2nmax
         Call hull( ping2_i, title, me, npes, nrpt, ncases, n, tn,
     &              ops )
         Call report( title, me, npes, nrpt, ncases, n, tn, ops,
     &                first, last )
      End Do

      Do log2n = 0, log2nmax
         n    = 2**log2n
         last = log2n .EQ. log2nmax
         Call hull( broadcast, title, me, npes, nrpt, ncases, n, tn,
     &              ops )
         Call report( title, me, npes, nrpt, ncases, n, tn, ops,
     &                first, last )
      End Do

      Do log2n = 0, log2nmax
         n    = 2**log2n
         last = log2n .EQ. log2nmax
         Call hull( collect, title, me, npes, nrpt, ncases, n, tn,
     &              ops )
         Call report( title, me, npes, nrpt, ncases, n, tn, ops,
     &                first, last )
      End Do

      Do log2n = 0, log2nmax
         n    = 2**log2n
         last = log2n .EQ. log2nmax
         Call hull( reduction, title, me, npes, nrpt, ncases, n, tn,
     &              ops )
         Call report( title, me, npes, nrpt, ncases, n, tn, ops,
     &                first, last )
      End Do
  
      Do log2n = 0, log2nmax
         n    = 2**log2n
         last = log2n .EQ. log2nmax
         Call hull( trans_2d, title, me, npes, nrpt, ncases, n, tn,
     &              ops )
         Call report( title, me, npes, nrpt, ncases, n, tn, ops,
     &                first, last )
      End Do

      Do log2n = 0, log2nmax
         n    = 2**log2n
         last = log2n .EQ. log2nmax
         Call hull( bisec2_reg, title, me, npes, nrpt, ncases, n, tn,
     &              ops )
         Call report( title, me, npes, nrpt, ncases, n, tn, ops,
     &                first, last )
      End Do

      Do log2n = 0, log2nmax
         n    = 2**log2n
         last = log2n .EQ. log2nmax
         Call hull( bisec2_rand, title, me, npes, nrpt, ncases, n, tn,
     &              ops )
         Call report( title, me, npes, nrpt, ncases, n, tn, ops,
     &                first, last )
      End Do

      Do log2n = 0, log2nmax
         n    = 2**log2n
         last = log2n .EQ. log2nmax
         Call hull( nearn_1d, title, me, npes, nrpt, ncases, n, tn,
     &              ops )
         Call report( title, me, npes, nrpt, ncases, n, tn, ops,
     &                first, last )
      End Do
 
      Do log2n = 0, log2nmax
         n    = 2**log2n
         last = log2n .EQ. log2nmax
         Call hull( nearn_2d, title, me, npes, nrpt, ncases, n, tn,
     &              ops )
         Call report( title, me, npes, nrpt, ncases, n, tn, ops,
     &                first, last )
      End Do

      Do log2n = 0, log2nmax
         n    = 2**log2n
         last = log2n .EQ. log2nmax
         Call hull( nearn_3d, title, me, npes, nrpt, ncases, n, tn,
     &              ops )
         Call report( title, me, npes, nrpt, ncases, n, tn, ops,
     &                first, last )
      End Do
     
      Call MPI_Finalize (ie)
! ----------------------------------------------------------------------
      End Program mod1h
