      Subroutine broadcast( title, me, npes, nrpt, ncases, n, tn,
     &                        ops )
! ----------------------------------------------------------------------
      Use             numerics
      Use             max_params      
      Implicit        None
      
      Include         'mpif.h'
      
      Character*50 :: title
      Integer      :: me, npes, nrpt, ncases, n
      Real(l_)     :: tn(maxcases), ops, timer
      Real(l_)     :: a(nmax)
      Real(l_)     :: t1, t2
      Integer      :: k, kk
      Integer      :: log2
      Integer      :: comm, ie, type
      External        log2
      Save            a
! ---------------------------------------------------------------------- 
      comm   = MPI_Comm_World
      type   = MPI_Real8
      title  = ' 1 PE    --> N PEs; Broadcast'
      nrpt   = 100
      ncases = npes
      ops    = log2(npes - 1)*8*n        
      tn(1:maxcases) = 1.0e-15_l_
      Do k = 0, npes-1
         a = 0.0_l_

         Call MPI_Barrier( comm, ie )
         t1 = timer()
         Do kk = 1,nrpt
            Call MPI_Bcast( a, n, type, k, comm, ie )
         End Do
         t2      = timer()
         tn(k+1) = Max( 1.0e-15_l_, ( t2 - t1 )/nrpt )
      End Do
! ---------------------------------------------------------------------- 
      End Subroutine broadcast
