      Subroutine bisec2_rand( title, me, npes, nrpt, ncases, n, tn,
     &                        ops )
! ----------------------------------------------------------------------
      Use            numerics
      Use            max_params      
      Implicit       None     
      Include        'mpif.h'
      
      Character*50 :: title
      Integer      :: me, npes, nrpt, ncases, n
      Real(l_)     :: tn(maxcases), ops, timer
      Real(l_)     :: a(nmax), b(nmax)      
      Real(l_)     :: t1, t2
      Integer      :: k, kk
      Integer      :: targ
      Logical      :: s
      Integer, Dimension(0:npes-1) :: p
      Logical, Dimension(0:npes-1) :: l
      Integer      :: comm, ie, tag1, tag2, type
      Integer      :: status(MPI_Status_Size)
      Save            a, b
! ----------------------------------------------------------------------      
      comm   = MPI_Comm_World
      title  = ' N/2 PEs<--  N/2 PEs; Bisect., Unidir., Rand.'
      type   = MPI_Real8
      nrpt   = 100
      ncases = 10
      ops    = 8*n
      tn(1:maxcases) = 1.0e-15_l_
      Do k = 1,ncases      
        If ( me == 0 ) Then
          Call rand_vpe( npes, l(0:npes-1), p(0:npes-1) )
        End If  
        Call MPI_Bcast(p, npes, MPI_Integer, 0, comm, ie)
        Call MPI_Bcast(l, npes, MPI_Logical, 0, comm, ie)

        targ = p(me)
        s    = l(me)
        tag1 = k*2
        tag2 = tag1+1
        b    = 0.0_l_ 
        Call MPI_Barrier( comm, ie )
 
        If ( s ) Then 
          t1 = timer()
          Do kk = 1, nrpt
            Call MPI_Send( a, n, type, targ, tag1, comm, ie )
            Call MPI_Recv( b, n, type, targ, tag2, comm, status, ie )
          End Do
          t2 = timer ()
          tn(k) = Max( 1.0e-12_l_, (t2 - t1)/(2*nrpt) )
        Else
          t1 = timer ()
          Do kk = 1, nrpt
            Call MPI_Recv( b, n, type, targ, tag1, comm, status, ie )
            Call MPI_Send( a, n, type, targ, tag2, comm, ie )
          End Do
          t2 = timer()
          tn(k) = Max( 1.0e-15_l_, (t2 - t1)/(2*nrpt) )
        End if
      End Do
! ----------------------------------------------------------------------
      End Subroutine bisec2_rand
