      Program mod2i
! ---------------------------------------------------------------------
!     Program 'mod2i' tests an iterative Quicksort algorithm with 
!     Integer and 8-byte Real data. Data are generated internally
!     by the Fortran 90-provided random generator.
! ---------------------------------------------------------------------
      Use                       numerics
      Use                       dist_module
      Implicit                  None
      Include                   'mpif.h'
     
      Integer, Allocatable   :: idata(:), src(:)
      Real(l_),  Allocatable :: ddata(:)
      Real(l_)               :: cor, dlog2, speed1, speed2, time1,
     &                          time2, time1t, time2t
      Integer                :: comm, dtype, i, ier, ltype, m, mx,
     &                          m_new, n, nops, nrep
      Logical                :: ok1, ok2, ok1t, ok2t
! ----------------------------------------------------------------------
      Call csetup
      comm  = MPI_Comm_World
      dtype = MPI_Real8
      ltype = MPI_Logical
      If ( me == 0 ) Then
         Call state( 'mod2i   ' )
      End If 
      Open( 1, File = 'mod2i.in' )
      If ( me == 0 ) Print 1000, nodes
   10 Read( 1, *, End = 20 ) n, nrep
      Call evdist( n )
!     Call bsaddr
      m  = sizes( me )
      mx = Maxval( sizes )
      mx = mx + mx
      Allocate( idata(mx), ddata(mx), src(mx) )!after reshuffling.
      Call ranint( 1, n, m, src )
      nops  = Int( n*dlog2( n ) )         ! --- Average work estimate!!

      time1 = MPI_Wtime()                 ! --- Integer sort.
      Do i = 1, nrep
         idata = src
         Call i_psrs( m, mx, idata, m_new )
         Call MPI_Barrier( comm, ier )
      End Do
      time1 = MPI_Wtime() - time1
      ok1 = .TRUE.                        ! --- Correctness check.
      Call icheck( idata, m_new, ok1 )    
      time2 = MPI_Wtime()                 ! --- 8-byte Real sort.
      Do i = 1, nrep
         ddata = Real( src, l_ )
         Call d_psrs( m, mx, ddata, m_new )
         Call MPI_Barrier( comm, ier )
      End Do
      time2 = MPI_Wtime() - time2
      ok2 = .TRUE.                        ! --- Correctness check.
      Call dcheck( ddata, m_new, ok2 )
      ok1t = .TRUE.
      ok2t = .TRUE.
      Call MPI_Reduce( ok1, ok1t, 1, ltype, MPI_Land, 0, comm, ier )
      Call MPI_Reduce( ok2, ok2t, 1, ltype, MPI_Land, 0, comm, ier )

      cor = MPI_Wtime()                   ! --- Correct timings.
      Do i = 1, nrep
         idata = src
         Call MPI_Barrier( comm, ier )
      End Do
      time1 = time1 - MPI_Wtime() + cor
      cor = MPI_Wtime()
      Do i = 1, nrep
         ddata = Real( src, l_ )
         Call MPI_Barrier( comm, ier )
      End Do
      time2 = time2 - MPI_Wtime() + cor
      
      Call MPI_Reduce( time1, time1t, 1, dtype, MPI_Max, 0, comm, ier )
      Call MPI_Reduce( time2, time2t, 1, dtype, MPI_Max, 0, comm, ier )
      speed1 = 1.0e-6_l_*Real( nrep*nops, l_ )/Max( time1t, 1.0e-9_l_ )
      speed2 = 1.0e-6_l_*Real( nrep*nops, l_ )/Max( time2t, 1.0e-9_l_ )
      
      If ( me == 0 ) Print 1010, n, time1t/nrep, speed1, ok1, 
     &               time2t/nrep, speed2, ok2  
      Deallocate( idata, ddata , src )
      Go To 10
   20 If ( me == 0 ) Print 1020
      Call MPI_Finalize( ier )
! ---------------------------------------------------------------------
 1000 Format( 'Quicksort test: No. of procs. = ', i3/
     &        '-------------------------------------------------------',
     &        '----------------'/,
     &        '  Order |  Integer   |  Integer  |     |   Double   |',
     &        '  Double   |     |'/,
     &        '    n   |  Time (s)  |  (Mop/s)  | OK? |  Time (s)  |',
     &        '  (Mop/s)  | OK? |'/,
     &        '-------------------------------------------------------',
     &        '----------------' )
 1010 Format( I7,' |', G11.4,' |', G11.4, '|', L3,'  |', G11.4,
     &        ' |', G11.4, '|', L3, '  |' )
 1020 Format( '-------------------------------------------------------',
     &        '----------------' )
c ----------------------------------------------------------------------
      End Program mod2i
