      Program mod2h
! **********************************************************************
! *** This program is part of the EuroBen Benchmark                  ***
! ***                                                                ***
! *** Copyright: EuroBen Group p/o                                   ***
! ***            Utrecht University, Computational Physics Dept.     ***
! ***            P.O. Box 80.000                                     ***
! ***            3508 TA Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Authors of this program: Aad van der Steen                     ***
! *** Date                    Spring 2003                            ***
! *** Adjustments of timing resolution and  problem set              ***
! *** by Aad van der Steen    Fall   2003                            ***
! **********************************************************************
!  Distributed Version 1.0
!
! --- EuroBen Benchmark Module 2h. Computes uniformly distributed random
!     numbers in the interval [0,1).
! ----------------------------------------------------------------------
      Use                      numerics
      Use                      dist_module
      Use                      ran_module
      Implicit                 None
      
      Real(l_), Allocatable :: a(:)
      Real(l_)              :: timebf, time
      Integer               :: n, nsize
      Integer               :: mylength
      Integer               :: er
      Real(l_)              :: gtime, nops
      Logical               :: ok

      Include                  'mpif.h'
! ----------------------------------------------------------------------
! --- Call identification routine and start MPI.

      Call csetup
      If ( me == 0 ) Call state( 'mod2h   ' )
      If ( me == 0 ) Print 1000, nodes
! ----------------------------------------------------------------------
! --- Fill A with random numbers and include initialisation overhead
!     in the timing.

      Open( 1, File = 'mod2h.in' )
   10 Read( 1, *, End = 20 ) nsize 
      n = mylength( nsize )
      Allocate( a(n) )
      x1 = 2003                          ! --- Seeds for random process.
      x2 = 2017
      timebf = MPI_Wtime()
      Call rinit( n, a, nodes, me )
      Call ranfil( a, n )
      time = MPI_Wtime() - timebf
      ok   = .TRUE.
      Call check( a, n, ok )
      Call MPI_Reduce( time, gtime, 1, MPI_Real8, MPI_Max, 0,
     &                     MPI_Comm_World, er )
      If ( me == 0 ) Then
         nops = 1.0e-6_l_*nsize/Max( gtime, 1.0e-15_l_ )
         Print 1010, nsize, gtime, nops, ok
      End If
      Deallocate( a )
      Go To 10
   20 If ( me == 0 ) Print 1020
      Call MPI_Finalize( er )
! ----------------------------------------------------------------------
 1000 Format(' Machine-independent random number generator dran2'/
     &       ' (including initialisation), nprocs = ', i3/
     &       '----------------------------------------'/
     &       '   Size |   Time(s)   |M rand.num/s |OK|'/
     &       '----------------------------------------' )
 1010 Format( i8, '|', g13.5, '|', g13.5, '|', l2, '|' )
 1020 Format('----------------------------------------' )
! ----------------------------------------------------------------------
      End Program mod2h
