      Function dran2()                               Result( ran )
! -----------------------------------------------------------------
      Use        numerics
      Use        ran_module
      Implicit   None

! -----------------------------------------------------------------
! --- dran2 returns a uniform deviate in [0,1).
!     dran2 is identical to Function dran0, except that the numbers
!     are generated with a spacing of 'k' elements in which k
!     is usually the number of processors in a parallel system
!     to be used.
!
! --- The algorithm is loosely based on an algorithm from
!     Press & Teukolsky et.al. and based on the linear congruential
!     method with choices for M, A, and C that are given by
!     D. Knuth in "Semi-numerical algorithms".
! --- Input parameters:
!     Integer  - ak1, ck1, m1, ak2, ck2, m2. The parameters of the 
!                two linear congruent relations used. They are 
!                passed via module 'ran_module'.
!     Integer  - x1, x2. Seeds for the two linear congruences.
!                Passed via module 'ran_module'.
!
! --- Output-parameters:
!     Real(l_) - ran.  Uniform deviate in (0,1)
! ------------------------------------------------------------------
!
      Real(l_)            :: ran
! ------------------------------------------------------------------
      x1  = Mod( ak1*x1 + ck1, m1 )
      x2  = Mod( ak2*x2 + ck2, m2 )
      ran = ( Real( x1, l_ ) + Real( x2, l_ )*rm2 )*rm1
! -----------------------------------------------------------------
      End Function dran2
