      Subroutine synhr2d( a1, a2, w1, w2, n1, n2, vsize, hsize, ctime )
! ---------------------------------------------------------------------
! --- 'synhr2d' does a 2-D Haar wavelet synthesis by means of 2 
!     sequences of 1-D syntheses. In between a global transpose must
!     be done by 'gtrans'. Input array is 'a2'; output array is 'a1'.
!     'w1' and 'w2' are output arrays.
! ---------------------------------------------------------------------
      Use         numerics   
      Use         dist_module ! Contains # of proc.s & proc. numbers.
      Implicit    None
      Include     'mpif.h'

      Integer  :: n1, n2, vsize, hsize
      Real(l_) :: a1(n1,hsize), a2(n2,vsize), w1(n1,hsize),
     &            w2(n2,vsize)
      Real(l_) :: ctime

      Integer  :: i, log2, m
      Integer  :: actsiz(0:nodes-1,2), base(0:nodes-1,2)
! ---------------------------------------------------------------------
      Call sizoff( n2, n1, actsiz, base )
      m  = log2( n2 )
      Do i = 1, actsiz(me,2)
         Call synthr( a2(1,i), w2(1,i), n2, m )
      End Do
      Call gtrans( w2, w1, n2, n1, hsize, vsize, ctime )
      m  = log2( n1 )
      Do i = 1, actsiz(me,1)
         Call synthr( w1(1,i), a1(1,i), n1, m )
      End Do
! ---------------------------------------------------------------------
      End Subroutine synhr2d
