      Program mod2g
! **********************************************************************
! *** This program is part of the EuroBen Benchmark                  ***
! *** Copyright: EuroBen Group p/o                                   ***
! ***            Utrecht University, Computational Physics Dept.     ***
! ***            P.O. Box 80195                                      ***
! ***            3508 TD Utrecht                                     ***
! ***            The Netherlands                                     ***
! ***                                                                ***
! *** Author of this program: Aad J. van der Steen                   ***
! *** Contributed:            Autumn 1998                            ***
! *** Improved communicaton:  Spring 2005                            ***
! **********************************************************************
!  Version 2.1
!
! --- Purpose of this module
!     ----------------------
!     This program performs 2-D Haar wavelet transforms as used in data
!     compression. Data are generated internally and, subsequently, a
!     wavelet analysis and sythesis are performed. The time and Mflop/s
!     for an analysis/synthesis pair are determined.
! ----------------------------------------------------------------------
      Use                      numerics
      Use                      dist_module ! Contains # of proc.s &
                                           ! proc. numbers.
      Implicit                 None
      Include                 'mpif.h'

      Real(l_), Allocatable :: a1(:,:), a2(:,:), w1(:,:), w2(:,:)
      Real(l_)              :: speed, time, timeg
      Real(l_)              :: ctime, ctimeg, pctime
      Integer, Allocatable  :: actsiz(:,:), base(:,:)
      Integer               :: hsize, i, ierr, n1, n2, nflops, nrep,
     &                         vsize
      Logical               :: ok, okg
! ----------------------------------------------------------------------
      Call csetup
      If ( me == 0 ) Call state( 'mod2g   ' )
      Open( 1, File = 'mod2g.in' )
      If ( me == 0 ) Print 1000, nodes
   10 Read( 1, *, End = 30 ) n1, n2, nrep
      Allocate( actsiz(0:nodes-1,2), base(0:nodes-1,2) )
      Call sizoff( n1, n2, actsiz, base )
      vsize  = Maxval( actsiz(:,1) )
      hsize  = Maxval( actsiz(:,2) )
      Allocate( a1(n1,hsize), a2(n2,vsize), w1(n1,hsize), w2(n2,vsize) )
      nflops = 5*(n2*(n1 - 1) + n1*(n2 - 1))
      Call gendat( a1, n1, actsiz(me,2), actsiz, base )
      time = MPI_Wtime()
      ctime = 0.0_l_
      Do i = 1, nrep
         Call anhr2d( a1, a2, w1, w2, n1, n2, vsize, hsize, ctime )
         Call synhr2d( a1, a2, w1, w2, n1, n2, vsize, hsize, ctime )
      End Do
      time = MPI_Wtime() - time
      Call MPI_Reduce( time, timeg, 1, MPI_Real8, MPI_Max, 0,
     &                 MPI_Comm_World, ierr )
      Call MPI_Reduce( ctime, ctimeg, 1, MPI_Real8, MPI_Max, 0,
     &                 MPI_Comm_World, ierr )
      pctime = 100.0_l_*(ctimeg/timeg)
      timeg  = timeg/Real( nrep, l_ )
      ctimeg = ctimeg/Real( nrep, l_ )
      speed = ( 1.0E-6_l_*nflops )/Max( timeg, 1.0E-9_l_ )
      Call gendat( w1, n1, actsiz(me,2), actsiz, base )    
      ok = .TRUE.
      Call check( w1, a1, hsize, n1, actsiz, ok )
      Call MPI_Reduce( ok, okg, 1, MPI_Logical, MPI_Land, 0,
     &                 MPI_Comm_World, ierr )
      If ( me == 0 ) Print 1010, n1, n2, timeg, speed, ctimeg, pctime,
     &                           okg    
      Deallocate( a1, a2, w1, w2 , actsiz, base )
      Go To 10
   30 If ( me == 0 ) Print 1020
      Call MPI_Finalize( ierr )
! ----------------------------------------------------------------------
 1000 Format( //, 'Haar wavelet transform test: No. of procs. = ', i3/
     &        '-------------------------------------------------------',
     &        '------------------------'/
     &        '    Order   | Exec. Time  |    Speed    | Comm. time  |',
     &        '  Frac.  | Correctness |'/
     &        '  n1 |  n2  |     (s)     |  (Mflop/s)  |     (s)     |',
     &        '   (%)   |      OK     |'/
     &        '-------------------------------------------------------',
     &        '------------------------' )
 1010 Format( i4,' | ',  i4,' |', g12.5,' |', g13.5, '|', g13.5,
     &        '| ', f7.3, ' |    ', l3, '      |' )
 1020 Format( '-------------------------------------------------------',
     &        '------------------------' )
! ----------------------------------------------------------------------
      End Program mod2g
