      Subroutine anhr2d( a1, a2, w1, w2, n1, n2, vsize, hsize, ctime )
! ---------------------------------------------------------------------
! --- Does the 2-D Haar Wavelet analysis by 2 sequences of 1-D
!     transforms. In between a global transpose is done. 'a1'
!     is the input array, 'a2' contains the output array. 'w1' and
!     'w2' are work arrays.
! ---------------------------------------------------------------------
      Use        dist_module ! Contains # of proc.s & proc. no.s
      Use        numerics
      Implicit   None
      Include    'mpif.h'

      Integer  :: n1, n2, vsize, hsize
      Real(l_) :: a1(n1,hsize), a2(n2,vsize), w1(n1,hsize),
     &            w2(n2,vsize)
      Real(l_) :: ctime

      Integer  :: actsiz(0:nodes-1,2), base(0:nodes-1,2)
      Integer  :: i, log2, m
! ---------------------------------------------------------------------
      Call sizoff( n1, n2, actsiz, base )
      m = log2( n1 )
      Do i = 1, actsiz(me,2)
         Call analhr( a1(1,i), w1(1,i), n1, m )
      End Do
      Call gtrans( w1, w2, n1, n2, vsize, hsize, ctime )
      m = log2( n2 )
      Do i = 1, actsiz(me,1)
         Call analhr( w2(1,i), a2(1,i), n2, m )
      End Do
! ---------------------------------------------------------------------
      End Subroutine anhr2d
