      Subroutine sym7mxv( n1, n2, n3, m, a, al, x, y )
! ---------------------------------------------------------------------
! --- sym7mxv does a matrix-vector multiply of a banded symmetric
!     matrix originating from a 3-D finite difference scheme.
!     The upper diagonal part of matrix a is stored in a(*,0:3)
!     (including the main diagonal).
!     The strict upper diagonal parts are also given in transposed
!     form in al(m,1:3) for ease of calculation, while the vectors
!     x and y are present entirely for the same reason.
! ---------------------------------------------------------------------
      Use         numerics
      Use         floptime
      Use         mpi_module
      Implicit    None

      Integer  :: m, n1 ,n2 ,n3
      Real(l_) :: a(m,0:3), al(m,1:3), x(n1*n2*n3), y(n1*n2*n3)

      Integer  :: n12, ntot
! ---------------------------------------------------------------------
      n12  = n1*n2
      ntot = n12*n3

! --- Main diagonal and upper diagonals.

      Call MPI_Allgatherv( x(lb), m, rtyp, x, sizes, offset, rtyp,
     &                     comm, ierr )
      y(lb:gub) = a(1:m,0)*x(lb:gub)
      y(glb+la1:glb+ua1) = y(glb+la1:glb+ua1) + a(la1:ua1,1)*
     &                     x(glb+la1+1:glb+ua1+1)
      y(glb+la2:glb+ua2) = y(glb+la2:glb+ua2) + a(la2:ua2,2)*
     &                     x(glb+la2+n1:glb+ua2+n1)
      y(glb+la3:glb+ua3) = y(glb+la3:glb+ua3) + a(la3:ua3,3)*
     &                     x(glb+la3+n12:glb+ua3+n12)
! ---------------------------------------------------------------------
! --- Lower diagonals.

      y(glb+lb1:glb+ub1) = y(glb+lb1:glb+ub1) + al(lb1:ub1,1)*
     &                     x(glb+lb1-1:glb+ub1-1)
      y(glb+lb2:glb+ub2) = y(glb+lb2:glb+ub2) + al(lb2:ub2,2)*
     &                     x(glb+lb2-n1:glb+ub2-n1)
      y(glb+lb3:glb+ub3) = y(glb+lb3:glb+ub3) + al(lb3:ub3,3)*
     &                     x(glb+lb3-n12:glb+ub3-n12)
      Call MPI_Allgatherv( y(lb), m, rtyp, y, sizes, offset, rtyp,
     &                     comm, ierr )
! ---------------------------------------------------------------------
! --- Keep track of flops.

      flops = flops + 13*m - 4*( n12 + n1 + 1 )
! ---------------------------------------------------------------------
      End Subroutine sym7mxv
