      Function nrm2( n, x )                               Result( sum )
! ---------------------------------------------------------------------
      Use         numerics
      Use         floptime
      Use         mpi_module
      Implicit    None

      Integer  :: n
      Real(l_) :: x(n)

      Integer  :: i
      Real(l_) :: lsum, sum
! ---------------------------------------------------------------------
      lsum = 0.0_l_
      Do i = 1, n
         lsum = lsum + x(i)*x(i)
      End Do
      Call MPI_Allreduce( lsum, sum, 1, rtyp, MPI_Sum, comm, ierr )
      flops = flops + 2*n                    ! --- Keep track of flops.
! ---------------------------------------------------------------------
      End Function nrm2
