      Subroutine lsqslv( m, n, a, x )
! ----------------------------------------------------------------------
! --- lsqslv solves the rectangular upper diagonal system Ax = b in
!     the Least Squares sense: It is assumed that m <= n and
!     a(n,m) has only a non-zero upper triangle of order m.
!     On entry x contains the RHS. On exit it contains the
!     solution vector.
! ----------------------------------------------------------------------
      Use         numerics
      Use         floptime
      Implicit    None

      Integer  :: m, n
      Real(l_) :: a(n,m), x(m)

      Integer  :: i, j
      Real(l_) :: tmp
! ----------------------------------------------------------------------
      Do j = m, 1, -1
         x(j) = x(j)/a(j,j)
         tmp = x(j)
         Do i = j - 1, 1, -1
            x(i) = x(i) - tmp*a(i,j)
         End Do
      End Do
      flops = flops + ( m*( m + 1 ) )/2
! ----------------------------------------------------------------------
      End Subroutine lsqslv

