      Subroutine lpolyn( n, nel, mp, indx, rowp, matvals, u, v, gamma )
! ----------------------------------------------------------------------
! --- Left polynomial preconditioner of order 'mp'.
!     
! ----------------------------------------------------------------------
      Use         numerics
      Use         floptime
      Use         mpi_module
      Implicit    None

      Integer  :: n, nel, mp
      Integer  :: indx(nel), rowp(n+1)
      Real(l_) :: matvals(nel)
      Real(l_) :: u(*), v(*)
      Real(l_) :: gamma(mp+1)

      Real(l_) :: w(n)
      Integer  :: i
! ----------------------------------------------------------------------
      v(lb:gub) = gamma(mp+1)*u(lb:gub)
      Do i = 1, mp
         Call spmxv( n, nel, indx, rowp, matvals, v, w )
         v(lb:gub) = v(lb:gub) - w
         v(lb:gub) = v(lb:gub) + gamma(mp-i+1)*u(lb:gub)
      End Do
      flops = flops + n*( 1 + 3*mp )
! ----------------------------------------------------------------------
      End Subroutine lpolyn
