      Subroutine getrs( m, n, a, lda, ipiv, b, info )
! -----------------------------------------------------------------------
      Use        numerics
      Use        dist_module
      Implicit   None
      Include    'mpif.h'

      Integer  :: m, n, lda  ! Dimension of factorization
      Integer  :: info       ! Result parameter (always zero)
      Integer  :: ipiv(*)    ! Pivot indices
      Real(l_) :: a(lda,*)   ! Factorization
      Real(l_) :: b(*)       ! Input vector, overwritten by solution
      Logical  :: send
      Integer  :: i, j, k    ! Counters
      Integer  :: comm, ierr
! -----------------------------------------------------------------------
      info = 0
      comm = MPI_Comm_World

      Call laswp( 1, b, m, 1, m, ipiv, 1 )

      Do i = 1, m                                     ! --- Solve L*Y = X
         If ( me == owner(i) ) Then
            If ( b(i) /= 0.0_l_ ) Then
               j = localindex(i)
               Do k = i+1, m
                  b(k) = b(k) - a(k,j)*b(i)
               End Do
            End If
         End If
         If ( i /= m ) Then
            Send = ( owner(i+1) /= owner(i) )
         Else
            Send = .TRUE.
         End If
         If ( Send )
     &      Call MPI_Bcast( b, m, MPI_Real8, owner(i), comm, ierr )
      End Do

      Do i = m, 1, -1                                 ! --- Solve U*Z = Y
         If ( me == owner(i) ) Then
            If ( b(i) /= 0.0_l_ ) Then
               j = localindex(i)
               b(i) = b(i)/a(i,j)
               Do k = 1, i-1
                  b(k) = b(k) - a(k,j)*b(i)
               End Do
            End If
         End If
         If ( i /= 1 ) Then
            Send = ( owner(i-1) /= owner(i) )
         Else
            Send = .TRUE.
         End If
         If (Send)
     &      Call MPI_BCast( b, m, MPI_Real8, owner(i), comm, ierr)
      End Do
! -----------------------------------------------------------------------
      End Subroutine getrs
