      Subroutine ger( m, n, alpha, x, incx, y, incy, a, lda )
! -----------------------------------------------------------------------
      Use         numerics
      Implicit    None

      Real(l_) :: alpha
      Integer  :: incx, incy, lda, m, n
      Real(l_) :: a(lda,*), x(*), y(*)
      Real(l_) :: temp
      Integer  :: i, info, ix, j, jy, kx
! -----------------------------------------------------------------------
      info = 0
      If (m < 0 ) Then
         info = 1
      Else If ( n < 0 ) Then
         info = 2
      Else If ( incx == 0 ) Then
         info = 5
      Else If ( incy == 0 ) Then
         Info = 7
      Else If ( lda < Max( 1, m ) ) Then
         Info = 9
      End If
      If ( Info /= 0 ) Then
         Call xerbla( 'GER   ', info )
         Return
      End If
      If ( ( m == 0 ) .OR. ( n == 0 ) .OR. ( alpha == 0.0_l_ ) ) Return
      If ( incy > 0 ) Then
         jy = 1
      Else
         jy = 1 - (n-1)*incy
      End If
      If ( incx == 1 ) Then
         Do j = 1, n
            If ( y(jy) /= 0.0_l_ ) Then
               temp = alpha*y(jy)
               Do i = 1, m
                  a(i,j) = a(i,j) + x(i)*temp
               End Do
            End If
            jy = jy + incy
         End Do
      Else
         If ( incx > 0 ) Then
            kx = 1
         Else
            kx = 1 - (m-1)*incx
         End If
         Do j = 1, n
            If ( y(jy) /= 0.0_l_ ) Then
               temp = alpha*y(jy)
               ix = kx
               Do i = 1, m
                  a(i,j) = a(i,j) + x(ix)*temp
                  ix = ix + incx
               End Do
            End If
            jy = jy + incy
         End Do
      End If
! -----------------------------------------------------------------------
      End Subroutine ger
