      Subroutine distribute( n, blocksize )
! -----------------------------------------------------------------------
      Use        dist_module
      Implicit   None

      Integer :: n, blocksize
      Integer :: i, rest
! -----------------------------------------------------------------------
      nb = blocksize
      Allocate( owner(n) )
      Allocate( localindex(n) )

      Do i = 1, n
         owner(i) = Mod( (i-1)/nb, nodes )
         rest = 1
         If ( me == owner(i) ) Then
            rest = Mod( i-1, nb ) + 1
         Else If ( me < owner(i) ) Then
            rest = nb + 1
         End If
         localindex(i) = ( (i-1)/( nodes*nb ) )*nb + rest
      End Do
! -----------------------------------------------------------------------
      End Subroutine distribute

