      Subroutine check( x, n, ok )
! ---------------------------------------------------------------------
! --- Routine 'check' checks the solution vector 'x' in 'b = Ax'. The
!     check is possible because of the special definition of 'A' & 'b'.
! ---------------------------------------------------------------------
      Use         numerics
      Use         dist_module
      Implicit    None
      Include     'mpif.h'

      Integer  :: n
      Real(l_) :: x(n)
      Logical  :: ok

      Integer  :: i, ierr
      Real(l_) :: eps
      Logical  :: lok
! ---------------------------------------------------------------------
      lok = .TRUE.
      eps = 4.0e4_l_*nodes*(n + 1)**2*Epsilon( 1.0_l_ )
      Do i = 1, n
         lok = lok .AND. ( Abs( x(i) - 1.0_l_ ) <= eps )
      End Do
      Call MPI_Reduce( lok, ok, 1, MPI_Logical, MPI_Land, 0,
     &                 MPI_Comm_World, ierr )
! ---------------------------------------------------------------------
      End Subroutine check
