      Subroutine gmxm( a, b, c, m, l, hsize, n )
! ----------------------------------------------------------------------
      Use         numerics
      Use         mpi_module
      Implicit    None

      Integer  :: m, l, hsize, n
      Real(l_) :: a(m,l), b(l,hsize), c(m,n)

      Real(l_) :: rbuf(l*n), sbuf(l*n)
      Integer  :: i
      Integer  :: left, right, rtag, stag, shift
! ----------------------------------------------------------------------
      right = me + 1
      If ( right > nodes - 1 ) right = 0
      left = me - 1
      If ( left < 0 ) left = nodes - 1
      Do i = 0, nodes - 1
         stag = i + 1
         rtag = stag
         shift = offset(i,2) + 1
         Call mxm( a, b, c(1,shift), m, m, l, sizes(i,2) )
         Call MPI_Sendrecv( b, l*hsize, rtyp, right, stag, 
     &                      b, l*hsize, rtyp, left,  rtag,
     &                      comm, stats, ier )
      End Do
! ----------------------------------------------------------------------
      End Subroutine gmxm

