      Subroutine timing( trans, m, n, a, lda, x, y, mvsr,
     &                   nrep, extime, perfor, wrk )
! ----------------------------------------------------------------------
! --- This routine performs the timing and calculates the performance
!     of the Matrix Vector multiplication routine MVSR
!
! --- Parameters
!     ----------
!  TRANS   - Input  - Determines the operation te be performed by MVSR
!  M, N    - Input  - Dimension of the problem
!  A(M,N)  - Input  - Contains the matrix A
!  LDA     - Input  - Leading Dimension of A
!  X(*)    - Input  - Contains the vector x
!  Y(*)    - Output - Contains result vector y
!  MVSR    - Input  - The matrix-vector multiplication routine
!  NREP    - Input  - The initial repetition factor to increase 
!                     accuracy of the timing
!  EXTIME  - Output - Contains the execution time for the operation
!  PERFOR  - Output - Contains the performance in Mflop/s
!  WRK     - Work space - used for intermediate storage of partial y
! ----------------------------------------------------------------------
      Use                    dist_module
      Use                    numerics
      Include                'mpif.h'

      Character*1         :: trans
      Integer             :: m, n, lda, nrep
      Real(l_)            :: a(lda,*), x(*), y(*), wrk(*)
      Real(l_)            :: extime, perfor
      External               mvsr
! ----------------------------------------------------------------------
! --- Local Constants
      Real(l_), Parameter :: zero = 0.0_l_, one = 1.0_l_

! --- Local variables
      Integer             :: nop
      Real(l_)            :: t1, t2
      Real(l_)            :: alpha, beta

! --- External functions and subroutines
      External               ddummy
! ----------------------------------------------------------------------
! --- Operation count

      If ( trans == 'N' ) Then
         nop = 2*m*n*nodes + 3*m*nodes
      Else
         nop = 2*m*n*nodes + (m + n)*nodes + n*(nodes - 1)
      End If
! ----------------------------------------------------------------------
! --- Set the ALPHA and BETA parameters

      alpha = one
      beta  = zero
      t1 = MPI_Wtime()
      Do k = 1, nrep
         Call mvsr( trans, m, n, alpha, a, lda, x, 1, beta, y, 1, wrk )
      End Do
      t2 = MPI_Wtime() - t1
! ----------------------------------------------------------------------
! --- Prevent smart compilers optimizing too much ...

      Call ddummy( y, 1 )

      extime =  t2 / nrep
      perfor = ( nop * 1.0e-06_l_ )/Max ( extime, 1.0e-9_l_ )
! ----------------------------------------------------------------------
      End Subroutine timing
