      Subroutine mkbnds( a, lda, ychk )
! ---------------------------------------------------------------------- 
! --- mkbnds calculates the result vector of y = Ax by independent 
!     means:
!           nodes  sizes(k)
!            ---     ---
!            \       \
!     y(j) =  >   k * >  a(j,i+offset(k)) 
!            /       /
!            ---     ---
!           k = 1   i = 1
!
!     k = 1,..., nodes
!     i = 1,..., sizes(*), where sizes(*) is the number of rows in
!                           node '*'.
!     j = 1,..., sizes(me)
!
! ----------------------------------------------------------------------
      Use                   dist_module 
      Use                   numerics    
      Real(l_)           :: a(lda,*), ychk(lda)

      Real(l_)           :: sum
      Integer            :: i, j, k, kbase
! ----------------------------------------------------------------------
      Do j = 1, sizes(me)
         ychk(j) = 0.0_l_
         Do k = 1, nodes
            sum = 0.0_l_
            kbase = offset(k-1)
            Do i = 1, sizes(k-1)
               sum = sum + a(j,kbase+i)
            End Do
            ychk(j) = ychk(j) + k*sum
         End Do
      End Do
! ----------------------------------------------------------------------
      End Subroutine mkbnds
