      Subroutine matgen ( a, x, lda, ncol )
! ---------------------------------------------------------------------
! --- Matgen generates the entries of the matrix A and the vector x.
!     These values are chosen such that y = Ax and y = A'x can be
!     checked easily.
!     The structure of A and x are as follows:
!
!              A:       ncol                    x:
!              __________/\______________
!             /                          \
!            _                      _    _   _    _   \
!          /  |  1    1    1    1   . . . |   |  1 |   |
!          |  |  1    2    3    4   . . . |   |  1 |   |
!          /  |  1    3    5    7   . . . |   |  1 |   |
! sizes(0) \  |  1    4    7   10   . . . |   |  1 |   |
!          |  |  .    .    .    .   . . . |   |  1 |   |
!          \  |  .    .    .    .   . . . |   |  1 |   |
!          ------------------------------------------- |
!          /  |  1  m+1  2m-1 3m-2  . . . |   |  2 |    \ Each of the
!          |  |  1  m+2  2m+1 3m+1  . . . |   |  2 |    / processors
!          /  |  1  m+3  2m+3 3m+4  . . . |   |  2 |   |  contains a
! sizes(1) \  |  1  m+4  2m+5 3m+7  . . . |   |  2 |   |  strip of A
!          |  |  .   .     .   .    . . . |   |  2 |   |  sizes(i)*ncol
!          \  |  .   .     .   .    . . . |   |  2 |   |  and the full
!          ------------------------------------------- |  vector x.
!                           .                    .     |  
!                           .                    .     |
!                           .                    .     / 
! ---------------------------------------------------------------------
      Use                   dist_module
      Use                   numerics
      Integer            :: ncol
      Real(l_)           :: a(lda,ncol), x(ncol)

      Integer            :: i, im1, j, k, kbase
! ---------------------------------------------------------------------
!                                                     ** Make vector x.
      Do k = 1, nodes
         kbase = offset(k-1)
         Do i = 1, sizes(k-1)
            x(kbase+i) =  Dble( k )
         End Do
      End Do
! ---------------------------------------------------------------------
!                                                     ** Make matrix A.
      kbase = offset(me) - 1
      Do j = 1, ncol         
         Do i = 1, sizes(me)
            a(i,j) = (kbase + i)*(j - 1) + 1
         End Do
      End Do
! ---------------------------------------------------------------------
      End Subroutine matgen
